<?php

defined('MOODLE_INTERNAL') || die();




/*
    ==========================
        ======================== This functions created for login section //Start============
*/
function igLoginPopUp()
{

    global $PAGE, $OUTPUT, $USER, $CFG;

    $output = '';
    $islogedin = isloggedin();
    $isguestusr = isguestuser();

    $loginicn = (!$islogedin || $isguestusr) ? 'cb-loginlock-icon' : 'cb-userafterlogin-icon';
    $logincls = ($islogedin && !$isguestusr) ? ' loggedin' : ' notloggedin';

    $loginstrng = (!$islogedin || $isguestusr)? get_string('login') :  $USER->firstname;
    $closetxt = get_string('closebuttontitle', 'core');
    

        // login section main starting DOM/HTML Element.
        $output .= '<div class="custom-login-wrapper">';

        if((!$islogedin or $isguestusr)){

            // DOM ELEMENT VISIBLE - Either user not loggged in or guest user.
            $output .= '<a href="javascript:void(0)" class="login-link login-popup' . $logincls . '" title="' . $loginstrng . '">';
            $output .= '<i class="cb-loginlock-icon"></i>';
            $output .= '</a>';
        }else{

            // DOM ELEMENT VISIBLE - Either user loggged in or not guest user.
            $output .= '<span class="login-link login-toggle' . $logincls .'">';
            $output .= $OUTPUT->user_picture($USER, array('size' => 35, 'class' => 'userpicture')) ;
            $output .= '<i class="cb-userafterlogin-icon"></i>';
            $output .= '</span>';
        }
        
        $output .= igLoginPopUpElements();
        $output .= '</div>';

    return $output;

}

/*
    ==========================
        ======================== This functions created for login section //End============
*/


/*
    ==========================
        ======================== This functions created for login form section //Start ============
*/

function igLoginPopUpElements()
{

    // GLOBAL VARIABLES - Moodle's default Variable.
    global $PAGE, $OUTPUT, $USER, $CFG;
    //Local Variables list
    $output = '';
    $logintoken = '';
    $cls = '';
    $weblink = '';
    $islogedin = isloggedin();
    $isguestusr = isguestuser();
    $Oauth = theme_ignite_moodle_theme_setting($PAGE, "Oauth_setting");
    $c_signup_link = theme_ignite_moodle_theme_setting($PAGE, "custom_signup_link");
    $c_signup_link_text = theme_ignite_moodle_theme_setting($PAGE, "custom_signup_link_text");
    $cansignup = ($CFG->registerauth === 'email' && !empty($CFG->registerauth));
    $loginLink = new moodle_url($CFG->wwwroot . '/login/forgot_password.php');
    $signupLink = new moodle_url($CFG->wwwroot . '/login/signup.php'); 


    if(empty($CFG->loginhttps)){
        $weblink = $CFG->wwwroot;
    }else{
        $weblink = str_replace('http://', 'https://', $CFG->wwwroot);
    }
    $login_url = $weblink . '/login/index.php?authldap_skipntlmsso=1';

    if (method_exists('\core\session\manager','get_login_token'))
    {
        $login_url = get_login_url();
        $logintoken = '<input type="hidden" name="logintoken" value="' . s(\core\session\manager::get_login_token()) .'" />';
    }

    // login section starting DOM/HTML Element.
    $output .= '<div class="ignite-login-section' . $cls . '" style="display:none;">';
    $output .= '<div class="ignite-login-wrapper">';

    

    if ( ( !$islogedin || $isguestusr ) )
    {
        // login section starting DOM/HTML Element.
        $output .= '<div class="login-section">';
        $output .= '<a href="#" class="cross-btn" title="' . get_string( 'closebuttontitle' ) . '">x</a>';
        // login section left panel.
        $output .= '<div class="left-panel">';
        if($c_signup_link){

           if(($loginLink !== '')  && $cansignup){

                $output .=  '<a target="_self" href="' . $signupLink . '">' . $c_signup_link_text . '</a>'; 
            } 
        }
        $output .= '</div>';
        // login section right panel.
        $output .= '<div class="right-panel">';
        $output .= '<h1>Log In</h1>';
        // login section form element.
        $output .= '<form id="login-form-section" method="post" action="' . $login_url. '">';
        $output .= '<div class="login-form-branch">';
        $output .= '<label id="user"><i class="cb-userbeforelogin-icon"></i></label>';
        $output .= '<input id="login-username" type="text" name="username" placeholder="User Name" />';
        $output .= '</div>';
        $output .= '<div class="login-form-branch">';
        $output .= '<label id="password-id"><i class="cb-password-icon"></i></label>';
        $output .= '<input id="login-password" type="password" name="password" placeholder="Password" />';
        $output .= '<i class="fa fa-eye-slash eye-icon eye-slash-hide" aria-hidden="false"></i>';
        $output .= '</div>';
        // login section submit button.
        $output .= '<button type="submit" class="submit_btn btn btn-primary">' . get_string('login', 'core') . '</button>';
        $output .= $logintoken;
        $output .= '</form>';

        $output .= '<p class="forgot_password"><a href="' . $loginLink . '">' . get_string('forgotten','core') . '</a></p>';

        // login Oauth Section.

        if ($Oauth) 
        {
            $authorder = get_enabled_auth_plugins(true); // All auths in order.
            $autharrlist = array();
            foreach ($authorder as $authnme)
            {
                $allauthplugin = get_auth_plugin($authnme);
                $autharrlist = array_merge($autharrlist, $allauthplugin->loginpage_idp_list
                    ($PAGE->url->out(false)));
            }

            if (!empty($autharrlist))
            {
                $output .= '<div class="autharrlist-section">';
                $output .= '<span>Or login with</span>';
                $output .= '<div class="autharrlist-wrap">';
                foreach ($autharrlist as $authv)
                {
                    $output .= '<div class="socialicon">';
                    $output .= '<a class="btn btn-default" ';
                    $output.= 'href="' . $authv['url']->out() . '" title="' . s($authv['name']) . '">';
                    if (!empty($authv['iconurl']))
                    {
                        $output .= '<img src="' . s($authv['iconurl']) . '" width="18" height="18"/>';
                    }
                    $output .= s($authv['name']) . '</a></div>';
                }
                $output .= '</div>';
                $output .= '</div>';
            }
        }

        $output .= '</div>'; // right-panel end
        $output .= '</div>'; // login-section end 

    }
    elseif ( $islogedin && !$isguestusr )
    {

        $output .= '<div class="user-section">';//It is for after login
        
            $output .= '<div class="user-profile-section">';
                $output .= $OUTPUT->user_picture($USER, array('size' => 45, 'class' => 'userpicture'));

                $output .= '<p>';
                    $output .= '<span>'. $USER->firstname . ' ' . $USER->lastname .'</span><br>';
                    $output .= '<span class="email">' . $emailStr = strlen($USER->email) > 21 ? substr($USER->email,0,21)."..." : $USER->email . '</span>';
                $output .= '</p>';
            $output .= '</div>'; //user profile section end

            $output .= '<div class="usermenu-menu-section">';
                $output .= $OUTPUT->user_menu();
            $output .= '</div>'; // usermenu-menu-section end

        $output .= '</div>'; //user section end
    }
    $output .= '</div>'; // ignite-login-wrapper end
    $output .= '</div>'; // ignite-login-section end

    return $output;

}


/*
    ==========================
        ======================== This functions created for login form section //End ============
*/


/*
    ==========================
        ======================== This functions created for search form section //Start ============
*/

    function getSearchForm(){

        //Global & Variables list 
        global $CFG;
        //Local Variables list
        $output = '';
        $def_àction_url = new moodle_url($CFG->wwwroot.'/course/search.php',array());
        $is_global_search = (isset($CFG->enableglobalsearch) && !empty($CFG->enableglobalsearch));
        $search_courses = get_string('searchcourses');
        $name = "search";
        $g_search = "<span class='g_search__message'>Please enable global searching if you require.</span>";
        //If gloabl search is enabled
        if($is_global_search){
            $def_àction_url = new moodle_url($CFG->wwwroot.'/search/index.php',array());
            $search_courses = get_string('globalsearch','admin');
            $name = "q";
            $g_search = "";
        }

        //HTML Renderer
        $output .= '<div class="cc_search__wrapper">';
            $output .= '<div class="cc_search__overlay">';
            $output .='<a href="javascript:void(0)" class="cc_search__close" id="search_screen__close"><i class="fa fa-times"></i></a>';
                $output .= '<div class="cc_search__modal">';
                    $output .= '<div class="cc_search__modal___inner">';
                        $output .= $g_search;
                        $output .= '<form id="theme-search" class="form_search__container" action="' . $def_àction_url . '">';
                        $output .= '<fieldset>';
                        $output .= '<input id="theme-coursesearchbox" class="input_search__field" type="text" name="'.$name.'" placeholder="' . $search_courses . '" tabindex="-1" size="15">';
                        $output.= '<input type="hidden" name="context" value="2">';
                        $output .= '<i class="cb-search-icon search_ic__icon"><input value="" type="submit"></i>';
                        $output .= '</fieldset>';
                        $output .= '</form>';
                    $output .= '</div>';
                $output .= '</div>';
            $output .= '</div>';
        $output .= '</div>';

        return $output;

    }


/*
    ==========================
        ======================== This functions created for search form section //End ============
*/




