<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2021 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'Over deze cursus';
$string['activity'] = 'Activiteit';
$string['action:changeassetvisibility'] = 'zichtbaarheid van set wijzigen';
$string['action:duplicateasset'] = 'dubbele set';
$string['action:changesectionvisibility'] = 'zichtbaarheid van secties wijzigen';
$string['action:highlightsectionvisibility'] = 'zichtbaarheid van sectie markeren';
$string['action:sectiontoc'] = 'sectie met inhoudsopgave ophalen';
$string['addanewsection'] = 'Een nieuwe sectie maken';
$string['addresourceoractivity'] = 'Leeractiviteit maken';
$string['admin'] = 'Beheer';
$string['advancedbrandingheading'] = 'Geavanceerd opmaak toevoegen';
$string['ago'] = 'geleden';
$string['answered'] = 'Beantwoord';
$string['appendices'] = 'Hulpmiddelen';
$string['assigndraft'] = 'Klad vereist je bevestiging';
$string['assignreopened'] = 'Heropend';
$string['at'] = 'om';
$string['attempted'] = 'Poging gedaan';
$string['basics'] = 'Basisinstellingen';
$string['brandingheading'] = 'Opmaak toevoegen';
$string['browse'] = 'Bladeren';
$string['browseallcourses'] = 'Bladeren in alle cursussen';
$string['cachedef_activity_deadlines'] = 'Cache-opslag voor deadlines voor gebruikersactiviteiten.';
$string['cachedef_generalstaticappcache'] = 'Snap algemene cache op statisch toepassingsniveau';
$string['cachedef_course_completion_progress'] = 'Dit wordt gebruikt om voltooiigingsgegevens per cursus/gebruiker in de cache op te slaan.';
$string['cachedef_course_completion_progress_ts'] = 'Dit wordt gebruikt om caches op sessieniveau ongeldig te kunnen verklaren indien de voltooiingsinstellingen voor een cursus of module veranderen.';
$string['cachedef_webservicedefinitions'] = 'Caching voor automatisch gegenereerde webservicedefinities.';
$string['card'] = 'Kaart';
$string['categoryedit'] = 'Bewerk categorie';
$string['category_color'] = 'Categoriekleur';
$string['category_color_description'] = 'Cursuscategoriekleur. Onderliggende cursussen nemen de configuratie van de dichtstbijzijnde bovenliggende categorie over.';
$string['category_color_palette'] = 'Kleurenpalet';
$string['category_color_palette_description'] = 'Raadpleeg de overeenkomstige hexadecimale waarde voor de desbetreffende kleur. Dit heeft geen invloed op configuraties en dient slechts ter illustratie om gebruikers te helpen de configuratiewaarde te bouwen.';
$string['changecoverimage'] = 'Omslagafbeelding wijzigen';
$string['changefullname'] = 'Wijzig sitenaam';
$string['chapters'] = 'Hoofdstukken';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" />';
$string['close'] = 'Sluit';
$string['conditional'] = 'Voorwaardelijk';
$string['contents'] = 'Inhoud';
$string['contributed'] = 'Bijgedragen';
$string['courses'] = 'Cursus';
$string['coursecontacts'] = 'Contactpersonen cursus';
$string['coursedisplay'] = 'Cursusweergave';
$string['coursefootertoggle'] = 'Cursusvoettekst';
$string['coursefootertoggledesc'] = 'De voettekst van de cursus bevat nuttige informatie voor gebruikers op een cursuspagina, waaronder cursuscontactpersonen, cursusbeschrijving en recente activiteiten in de cursus.';
$string['courseformatnotification'] = 'De huidige cursusstructuur die je gebruikt, wordt niet volledig ondersteund door het thema Snap. Voor de beste ervaring adviseert Open LMS dat je de cursusstructuur Onderwerpen of Wekelijks gebruikt met het thema Snap. Je kunt de cursusstructuur wijzigen in de <a href="{$a}">cursusinstellingen</a>.';
$string['coursefixydefaulttext'] = 'Je bent op dit moment niet ingeschreven bij een cursus.<br>Cursussen waarvoor je bent ingeschreven, worden hier getoond.';
$string['coursegrade'] = 'Cursuscijfer:';
$string['coursepartialrender'] = 'Vertraagd laden inschakelen voor cursussecties';
$string['coursepartialrenderdesc'] = 'Als deze optie is ingeschakeld, worden cursussecties op aanvraag geladen wanneer de gebruiker deze selecteert. Zo kunnen cursussen met een grote hoeveelheid inhoud sneller worden geladen.';
$string['coursenavigation'] = 'Cursusnavigatie';
$string['coursesummaryfilesunsuitable'] = 'Maak je cursussamenvattingsbestanden leeg voordat je probeert de omslagafbeelding te wijzigen';
$string['coursetools'] = 'Cursusdashboard';
$string['coverdisplay'] = 'Omslagweergave';
$string['covercarousel'] = 'Omslagcarousel';
$string['covercarouselon'] = 'Omslagcarousel gebruiken';
$string['covercarouseldescription'] = '<p>De carousel is een set roulerende banners of een diapresentatie die op de startpagina van je site wordt weergegeven in plaats van de omslagafbeelding.</p>
<p>Je kunt maximaal 3 afbeeldingen, een titel voor elke dia en een optionele ondertitel toevoegen. Afbeeldingen van 1200 x 600 pixels werken het beste.</p>';
$string['coverimage'] = 'Omslagafbeelding';
$string['covervideo'] = 'Omslagvideo';
$string['comingsoon'] = 'Binnenkort!';
$string['createsection'] = 'Sectie maken';
$string['current'] = 'Huidige';
$string['customcss'] = 'Aangepaste CSS';
$string['customcssdesc'] = 'Wees je bewust van je verantwoordelijkheid. Elk probleem dat wordt veroorzaakt door de CSS die hier wordt toegevoegd, moet je zelf oplossen. Open LMS Support kan je niet helpen met CSS-inhoud.';
$string['customtopbar'] = 'Navigatiebalk';
$string['customisenavbar'] = 'Kleuren van navigatiebalk wijzigen';
$string['customisenavbutton'] = 'Kleuren van de knop Mijn cursussen wijzigen';
$string['customisecustommenu'] = 'Aangepaste menukleur wijzigen';
$string['custommenutext'] = 'Aangepaste menukleur';
$string['deadlines'] = 'Deadlines';
$string['deadlinestoggle'] = 'Deadlines';
$string['deadlinestoggledesc'] = 'Gebruikers alle aanstaande deadlines voor activiteiten tonen voor cursussen waarvoor ze zijn ingeschreven.';
$string['defaultsummary'] = 'Gebruik dit gebied om het onderwerp te beschrijven, met tekst, afbeeldingen, audio en video.';
$string['defaultintrosummary'] = 'Welkom bij je nieuwe cursus {$a}.
<br>Beschrijf om te beginnen waar je cursus over gaat aan de hand van tekst, afbeeldingen, audio en video.';
$string['defaulttopictitle'] = 'Naamloos onderwerp';
$string['debugerrors'] = 'Fouten oplossen';
$string['deleteassetconfirm'] = 'Verwijder {$a}';
$string['deletingasset'] = '{$a} verwijderen';
$string['deletingassetname'] = 'Bezig met verwijderen van {$a->type} "{$a->name}"';
$string['deletesectionconfirm'] = 'Sectie verwijderen';
$string['deletingsection'] = 'Sectie {$a} verwijderen';
$string['draft'] = 'Niet gepubliceerd voor studenten';
$string['dropzonelabel'] = 'Versleep bestanden om ze bij te voegen of kies ervoor om te <span class="fake-link">bladeren</span>';
$string['due'] = 'Inleverdatum {$a}';
$string['edit'] = '"{$a}" bewerken';
$string['editcoursecontent'] = 'Blokken bewerken';
$string['editcoursesettings'] = 'Cursusinstellingen';
$string['editcoursetopic'] = 'Sectie bewerken';
$string['editcustomfooter'] = 'Voettekst bewerken';
$string['editcustommenu'] = 'Aangepast menu bewerken';
$string['error'] = 'Fout';
$string['errorgettingfeed'] = 'Er is een fout opgetreden bij het ophalen van feeditems.';
$string['error:categorycolorinvalidjson'] = 'Onjuiste JSON-indeling voor cursuscategorieën';
$string['error:categorycolorinvalidvalue'] = 'Record-ID of kleurwaarde voor categorie "{$a}" is niet geldig';
$string['error:categorynotfound'] = 'De categorierecord met ID "{$a}" is niet gevonden';
$string['error:coverimageexceedsmaxbytes'] = 'Omslagafbeelding is groter dan de maximumgrootte voor de site ({$a})';
$string['error:coverimageresolutionlow'] = 'Voor de beste kwaliteit raden we een grotere afbeelding aan van minstens 1024 px breed.';
$string['error:duplicatedcategoryids'] = 'Onjuiste JSON-indeling; enkele ID\'s zijn gedupliceerd';
$string['error:failedtochangeassetvisibility'] = 'Kan set niet verbergen/tonen';
$string['error:failedtochangesectionvisibility'] = 'Kan sectie niet verbergen/tonen';
$string['error:failedtohighlightsection'] = 'Kan sectie niet markeren';
$string['error:failedtoduplicateasset'] = 'Kan niet dupliceren';
$string['error:failedtodeleteasset'] = 'Kan set niet verwijderen';
$string['error:failedtotoc'] = 'Kan de inhoudsopgave niet ophalen.';
$string['extension'] = 'Extensie {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'De url van je Facebook-pagina.';
$string['favicon'] = 'Favorietpictogram';
$string['favicondesc'] = 'Favicons worden in het adresveld van je browser, in je bladwijzers en in mobiele snelkoppelingen weergegeven.';
$string['favorite'] = 'Favoriet {$a}';
$string['favorited'] = 'Als favoriet gekozen {$a}';
$string['featurespots'] = 'Uitgelichte spots';
$string['featurespotsedit'] = 'Uitgelichte spots bewerken';
$string['featurespotshelp'] = '<p>Je kunt maximaal 3 uitgelichte spots op de startpagina van je site plaatsen om de belangrijkste voordelen aan je huidige en potentiële gebruikers te tonen.</p>
<p>Je kunt een titel, inhoud en een optionele afbeelding toevoegen voor elke uitgelichte spot. Afbeeldingen moeten een vierkant zijn en mogen niet groter zijn dan 200 px x 200 px.</p>';
$string['featurespotsheading'] = 'Titel uitgelichte spots';
$string['featureonetitle'] = 'Uitgelichte spot 1 titel';
$string['featuretwotitle'] = 'Uitgelichte spot 2 titel';
$string['featurethreetitle'] = 'Uitgelichte spot 3 titel';
$string['featureonetitlelink'] = 'Titelkoppeling functie 1';
$string['featuretwotitlelink'] = 'Titelkoppeling functie 2';
$string['featurethreetitlelink'] = 'Titelkoppeling functie 3';
$string['featuretitlelinkdesc'] = 'Typ de URL waaraan je dit functiepunt wilt koppelen. Je kunt externe of interne koppelingen toevoegen binnen de site. Als je een interne koppeling wilt toevoegen, kopieer je deze uit de site-URL met /. Als je bijvoorbeeld een koppeling naar een cursus wilt toevoegen, ziet die eruit als "course/view.php?id=160". Als je een externe koppeling wilt toevoegen, begin je de koppeling met https://';
$string['featureonetitlecb'] = 'Functie 1 geopend in een nieuw venster';
$string['featuretwotitlecb'] = 'Functie 2 geopend in een nieuw venster';
$string['featurethreetitlecb'] = 'Functie 3 geopend in een nieuw venster';
$string['featuretitlecbdesc'] = 'Indien ingeschakeld, wordt de koppeling die is toegevoegd aan het functiepunt in een nieuw venster geopend.';
$string['featureonetext'] = 'Uitgelichte spot 1 inhoud';
$string['featuretwotext'] = 'Uitgelichte spot 2 inhoud';
$string['featurethreetext'] = 'Uitgelichte spot 3 inhoud';
$string['featureoneimage'] = 'Uitgelichte spot 1 afbeelding';
$string['featuretwoimage'] = 'Uitgelichte spot 2 afbeelding';
$string['featurethreeimage'] = 'Uitgelichte spot 3 afbeelding';
$string['featuredcourses'] = 'Uitgelichte cursussen';
$string['featuredcourseshelp'] = 'Markeer maximaal 8 uitgelichte cursussen voor de startpagina van je site. Voer de cursus-id in om een cursus uit te lichten.';
$string['featuredcoursesheading'] = 'Titel uitgelichte cursussen';
$string['featuredcourseone'] = 'Uitgelichte cursus 1';
$string['featuredcoursetwo'] = 'Uitgelichte cursus 2';
$string['featuredcoursethree'] = 'Uitgelichte cursus 3';
$string['featuredcoursefour'] = 'Uitgelichte cursus 4';
$string['featuredcoursefive'] = 'Uitgelichte cursus 5';
$string['featuredcoursesix'] = 'Uitgelichte cursus 6';
$string['featuredcourseseven'] = 'Uitgelichte cursus 7';
$string['featuredcourseeight'] = 'Uitgelichte cursus 8';
$string['featuredcoursesedit'] = 'Uitgelichte cursussen bewerken';
$string['featuredcoursesbrowseall'] = 'Bladeren in alle cursussen';
$string['featuredcoursesbrowsealldesc'] = 'Een koppeling toevoegen voor het bladeren door alle cursussen';
$string['feedbackavailable'] = 'Feedback beschikbaar';
$string['feedbacktoggle'] = 'Feedback en beoordeling';
$string['feedbacktoggledesc'] = 'Studenten hun meest recente feedback tonen en docenten de meest recente inzendingen die moeten worden beoordeeld.';
$string['footnote'] = 'Voettekst site';
$string['footnotedesc'] = 'Je voettekst wordt op de gehele site weergegeven. Dit is de beste plaats om koppelingen te plaatsen naar de Help, ondersteuning en andere sites van je organisatie die je wilt delen met studenten en docenten, bijvoorbeeld de bibliotheek of een e-mailadres.';
$string['forcepwdwarningpersonalmenu'] = 'Je moet <a href="{$a}">je wachtwoord wijzigen</a> voordat je het persoonlijke menu gebruikt.';
$string['forumauthor'] = 'Auteur';
$string['forumlastpost'] = 'Laatste bericht';
$string['forumpicturegroup'] = 'Groep';
$string['forumreplies'] = 'Antwoorden';
$string['forumtopic'] = 'Onderwerp';
$string['forumposts'] = 'Forumberichten';
$string['forumpoststoggle'] = 'Forumberichten';
$string['forumpoststoggledesc'] = 'Gebruikers de tien meest recente forumberichten uit hun cursussen tonen.';
$string['fullname'] = 'Sitenaam';
$string['fullnamedesc'] = 'De naam van je site.';
$string['graderadviseuserreport'] = 'Het "beoordelingsrapport" werkt niet goed op mobiele apparaten. In plaats daarvan wordt het "gebruikersrapport" geadviseerd';
$string['grading'] = 'Beoordeling';
$string['help'] = 'Help';
$string['helpguide'] = 'Handleiding';
$string['headingfont'] = 'Lettertype koptekst';
$string['headingfont_desc'] = 'Dit lettertype wordt gebruikt in de kopteksten (elementen h1 - h6) op de gehele site. Als je een aangepast weblettertype gebruikt, vergeet dit dan niet toe te voegen aan het extra moodle-html-formulier.';
$string['helpwithlogin'] = 'Hulp bij aanmelden';
$string['helpwithloginandguest'] = 'Hulp bij aanmelden/gastentoegang';
$string['hiddencoursestoggle'] = 'Verborgen cursussen';
$string['highlightedsection'] = 'gemarkeerd';
$string['home'] = 'startpagina';
$string['image'] = 'afbeelding';
$string['images'] = 'Afbeeldingen';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'De url van je instagram-account.';
$string['introduction'] = 'Introductie';
$string['jsontext'] = 'JSON-tekst';
$string['jsontextdescription'] = 'Het tekstgebied valideert de desbetreffende JSON, waardoor alleen bestaande categorieën zijn toegestaan, alleen numerieke waarden geldig zijn voor ID-records (categorierecords) en alleen hexadecimale waarden worden geaccepteerd als kleuren.
Voorbeeld::<br>
{"1":"#FAAFFF",<br>
"45":"#AFF",<br>
"65":"#FFF228",<br>
"12":"#CC0084",<br>
"56":"#CC0087",<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Open LMS Knowledge Base';
$string['list'] = 'Lijst';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'De URL van de LinkedIn-account van je organisatie.';
$string['leftnav'] = 'Inhoudstafel';
$string['leftnavdesc'] = 'Selecteer waar de inhoudsopgave moet worden weergegeven. De lijst biedt meer ruimte voor inhoud en werkt goed voor cursussen met veel onderwerpen.';
$string['loading'] = 'Laden...';
$string['loggedinasguest'] = 'Je bent aangemeld als gast';
$string['loggedoutmsg'] = 'Je bent momenteel afgemeld. Als je deze site wilt blijven gebruiken, moet je je weer aanmelden.';
$string['loggedoutmsgtitle'] = 'Je bent afgemeld';
$string['loggedoutfailmsg'] = 'Je moet aangemeld zijn om te {$a}.';
$string['loginform'] = 'Login';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Je logo wordt weergegeven in de koptekst op de gehele site.';
$string['menu'] = 'Mijn cursussen';
$string['messageread'] = 'Bericht gelezen';
$string['messages'] = 'Berichten';
$string['messagestoggle'] = 'Berichten';
$string['messagestoggledesc'] = 'Gebruikers hun meest recente berichten tonen die ze in de afgelopen 12 weken hebben ontvangen.';
$string['more'] = 'More';
$string['morenews'] = 'Meer nieuws';
$string['movingstartedhelp'] = 'Navigeer naar waar je een sectie wilt plaatsen "{$a}"';
$string['movingdropsectionhelp'] = 'Plaats sectie "{$a->moving}" voor sectie "{$a->before}"';
$string['moving'] = '"{$a}" verplaatsen';
$string['movingcount'] = '{$a} objecten verplaatsen';
$string['movefailed'] = 'Verplaatsen mislukt voor "{$a}"';
$string['move'] = '\'{$a}\' verplaatsen';
$string['movehere'] = 'Verplaats naar hier';
$string['movesection'] = 'Sectie verplaatsen';
$string['navbarbg'] = 'Achtergrondkleur';
$string['navbarlink'] = 'Tekstkleur';
$string['navbarbuttoncolor'] = 'Achtergrondkleur';
$string['navbarbuttonlink'] = 'Tekstkleur';
$string['nextsection'] = 'Nieuwe sectie';
$string['nodeadlines'] = 'Je hebt geen komende deadlines.';
$string['noforumposts'] = 'Je hebt geen relevante forumberichten.';
$string['nograded'] = 'Je hebt geen recente feedback.';
$string['nograding'] = 'Je hebt geen inzendingen die een cijfer nodig hebben.';
$string['nomessages'] = 'Je hebt geen berichten.';
$string['notanswered'] = 'Niet beantwoord';
$string['notattempted'] = 'Niet geprobeerd';
$string['notcontributed'] = 'Niet bijgedragen';
$string['notpublished'] = 'Niet gepubliceerd voor studenten';
$string['notsubmitted'] = 'Niet ingezonden';
$string['overdue'] = 'Te laat';
$string['personalmenu'] = 'Persoonlijk menu';
$string['personalmenufeatures'] = 'Functies persoonlijk menu';
$string['personalmenulogintoggle'] = 'Toon persoonlijk menu bij het aanmelden';
$string['personalmenulogintoggledesc'] = 'Opent het persoonlijke menu onmiddellijk na het aanmelden';
$string['personalmenuadvancedfeedsenable'] = 'Geavanceerde feeds inschakelen';
$string['personalmenuadvancedfeedsenabledesc'] = 'Met geavanceerde feeds worden bepaalde persoonlijke menu-items geladen, waardoor inhoud sneller op aanvraag wordt weergegeven en vernieuwd.';
$string['personalmenuadvancedfeedsperpage'] = 'Aantal weergegeven items in geavanceerde feeds';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Kies het aantal items dat je in de feed wilt weergeven. Gebruikers kunnen <strong>Meer weergeven</strong> selecteren om meer items weer te geven.';
$string['personalmenuadvancedfeedslifetime'] = 'Levensduur geavanceerde feeds';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Kies hoe lang de feeds in de browsercache blijven opgeslagen na het aanmelden. Als de waarde op 0 wordt ingesteld, worden de feeds niet opgeslagen in de browsercache.';
$string['personalmenurefreshdeadlines'] = 'Deadlines vernieuwen met een geplande taak.';
$string['personalmenurefreshdeadlinesdesc'] = 'Bij de uitvoering van deze taak worden de data van deadlines vernieuwd om de laadtijd van pagina’s te verkorten.';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Omslagafbeelding';
$string['posterdesc'] = 'Een grote headerafbeelding voor de startpagina van je site. Liggende afbeeldingen (1200 x 600 pixels) of groter werken het beste.';
$string['poweredbyrunby'] = 'Gebouwd met <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
een op <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a> gebaseerd product.<br>
Copyright &#169; {$a->year} Open LMS, alle rechten voorbehouden.';
$string['previoussection'] = 'Vorige sectie';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'De cursus-ID van de cursus die de gebruiker als favoriet heeft ingesteld';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'De gebruikers-ID van de gebruiker die de cursus als favoriet heeft ingesteld';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'Het tijdstempel dat aangeeft wanneer de gebruiker de cursus als favoriet heeft ingesteld';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Hiermee worden favoriete cursussen van gebruikers opgeslagen voor Snap';
$string['problemsfound'] = 'Gevonden problemen';
$string['progress'] = 'Voortgang';
$string['readmore'] = 'Meer lezen&nbsp;»';
$string['recentactivity'] = 'Recente activiteit';
$string['recentfeedback'] = 'Feedbackformulieren';
$string['region-main'] = 'Hoofd';
$string['region-side-main-box'] = 'Hoofd';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['region-side-top'] = 'Naar boven';
$string['released'] = 'Release: {$a}';
$string['reopened'] = 'Heropend';
$string['resourcedisplay'] = 'Bronweergave';
$string['resourcedisplayhelp'] = 'Selecteer hoe bijlagen en koppelingen in je cursus moeten worden weergegeven. Het Snap-thema biedt geen ondersteuning voor multimediabestanden in de beschrijving van kleine activiteit- en bronkaarten.';
$string['displaydescription'] = 'Toon beschrijving';
$string['displaydescriptionhelp'] = 'Selecteer om als eerste een beschrijving van de bron en URL-activiteiten weer te geven op een nieuwe pagina. Leerlingen openen inhoud vanuit de beschrijving.';
$string['search'] = 'Inhoud zoeken';
$string['seriffont'] = 'Lettertype Serif';
$string['seriffont_desc'] = 'Dit lettertype wordt gebruikt voor de meeste door gebruikers gegenereerde inhoud. Gebruik een serif-lettertype om door gebruikers gemaakte inhoud beter leesbaar te maken, en de inhoud meer te doen aanvoelen alsof hij door een mens is geschreven.';
$string['showcoursegradepersonalmenu'] = 'Cijfers';
$string['showcoursegradepersonalmenudesc'] = 'Gebruikers hun cijfer tonen in cursuskaarten in het persoonlijke menu';
$string['socialmedia'] = 'Social media';
$string['submitted'] = 'Ingestuurd';
$string['sitedescription'] = 'Sitebeschrijving';
$string['subtitle'] = 'Ondertitel';
$string['subtitle_desc'] = 'Geef je gebruikers een korte beschrijving van je site.';
$string['themecolor'] = 'Sitekleur';
$string['themecolordesc'] = 'Felle kleuren werken het best en geven je site een moderne uitstraling.';
$string['title'] = 'Titel';
$string['top'] = 'Naar boven';
$string['topbarbgcolor'] = 'Kleur van navigatiebalk';
$string['topbarlinkcolor'] = 'Kleur van navigatiebalkkoppeling en -pictogram';
$string['topbarbuttoncolor'] = 'Achtergrond van Mijn cursussen';
$string['togglenavigation'] = 'Navigatie schakelen';
$string['topicactions'] = 'Onderwerpacties';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'De url van je Twitter-account.';
$string['unenrolme'] = 'Maak mijn inschrijving ongedaan';
$string['enrolme'] = 'Laat me in de cursus';
$string['unread'] = 'ongelezen';
$string['unsupportedcoverimagetype'] = 'Afbeeldingstype voor omslag ({$a}) niet ondersteund';
$string['via'] = 'via';
$string['viewcourse'] = 'Cursus bekijken';
$string['viewmore'] = 'Bekijk meer';
$string['viewyourprofile'] = 'Je profiel bekijken';
$string['viewmyfeedback'] = 'Mijn feedback bekijken';
$string['viewcalendar'] = 'Toon mijn kalender';
$string['viewforumposts'] = 'Toon mijn forumberichten';
$string['viewmessaging'] = 'Toon mijn berichten';
$string['vieworiginalimage'] = 'Originele afbeelding weergeven';
$string['visibility'] = 'Zichtbaarheid';
$string['xofyanswered'] = '{$a->completed} van {$a->participants} beantwoord';
$string['xofyattempted'] = '{$a->completed} van {$a->participants} gepoogd';
$string['xofycontributed'] = '{$a->completed} van {$a->participants} bijgedragen';
$string['xofysubmitted'] = '{$a->completed} van {$a->participants} ingezonden';
$string['xungraded'] = '{$a} nog geen cijfer';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'De url van je YouTube-kanaal.';
$string['showallsectionsdisabled'] = 'Wegens de ontwerptaal is "Toon alle secties op één pagina" niet beschikbaar in Snap.';
$string['disabled'] = 'Uitgeschakeld';
$string['showappearancedisabled'] = 'De ontwerptaal van Snap voorkomt wijzigingen van weergave-instellingen.';
$string['pbb'] = 'Profielgebaseerde opmaak';
$string['pbb_description'] = 'Schakel <strong>Profielgebaseerde opmaak</strong> in om de opmaak voor een specifieke groep gebruikers te baseren op het gekozen gebruikersprofielveld.
<ul><li>Er wordt <em>slugification</em> toegepast op de waarde van het gebruikersveld; hierbij worden alle tekens omgezet in kleine tekens en worden ze van elkaar gescheiden met een koppelteken (-)</li>
<li>De tekenreeks <code>snap-pbb-</code>wordt toegevoegd als voorvoegsel</li>
<li>Deze klasse wordt toegevoegd aan de HTML-tag <code>body</code></li></ul>
De waarde <em>Blueberry Extravaganza</em> voor het gebruikersveld ziet er na slugification bijvoorbeeld uit als <code>snap-pbb-blueberry-extravaganza</code><br /><br />
Deze functie wordt gebruikt in combinatie met <a href="https://help.blackboard.com/Blackboard_Open_LMS/Administrator/Manage_a_Site/Course_and_Site_Design/Themes/Snap#advanced-branding_OTP-3" target="_blank">aangepaste CSS</a>.
Je moet CSS-selectors toevoegen met behulp van de nieuwe klassen in het gedeelte <a class="snap-settings-tab-link" href="#themesnapbranding">Basisinstellingen</a>.';
$string['pbb_enable'] = 'Profielgebaseerde opmaak inschakelen';
$string['pbb_enable_description'] = 'Hiermee wordt de klasse alleen toegevoegd aan de tag body indien actief.';
$string['pbb_field'] = 'Te gebruiken gebruikersveld';
$string['pbb_field_description'] = 'Er wordt slugification toegepast op de waarde van dit veld, waarna de waarde wordt gebruikt als de naam van een CSS-klasse voorafgegaan door <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Caching voor profielgebaseerde opmaak.';
$string['cachedef_course_card_bg_image'] = 'Caching voor achtergrondafbeelding cursus.';
$string['cachedef_course_card_teacher_avatar'] = 'Caching voor avatars docent.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Caching voor index van avatars docent.';
$string['accessforumstringdis'] = 'Weergave-opties';
$string['accessforumstringmov'] = 'Verplaatsopties';
$string['accesscalendarstring'] = 'Kalender';
$string['accessglobalsearchstring'] = 'Zoek';
$string['admineventwarning'] = 'Om gebeurtenissen uit alle cursussen te zien,';
$string['gotocalendarsnap'] = 'ga je naar de agenda van de site.';
$string['quizattemptswarn'] = 'Pogingen van geschorste gebruikers uitsluiten';
$string['quizfeedback'] = 'Feedbackformulieren';
$string['validratio'] = 'Deze combinatie van kleuren voldoet niet aan de minimale ratiowaarde van 4.5:1 van WCAG 2.0';
$string['invalidratio'] = 'Deze kleurencombinatie voldoet niet aan de
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">minimale ratiowaarde van 4.5:1 van WCAG 2.0</a>. Waarde: "{$a}"';
$string['imageinvalidratio'] = 'Deze afbeelding kan contrastproblemen veroorzaken omdat er niet wordt voldaan aan de minimale ratiowaarde van 4.5:1 van WCAG 2.0. Gemiddelde pixelwaarde: "{$a}"';
$string['catinvalidratio'] = 'De volgende kleurcategorieën voldoen niet aan de
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">minimale ratiowaarde van 4.5:1 van WCAG 2.0</a> :
Achtergrondkleur van site (wit): "{$a->white}". Achtergrondkleur van navigatiebalk: "{$a->custombar}". Achtergrondkleur van knop Mijn cursussen: "{$a->customnav}"';
$string['imageinvalidratiocategory'] = 'Deze afbeelding kan contrastproblemen veroorzaken omdat de themakleur niet voldoet aan de minimale ratiowaarde van 4.5:1 van WCAG 2.0. Gemiddelde pixelwaarde: "{$a}"';
$string['lazyload_mod_page'] = 'Standaard vertraagd laden inschakelen voor paginabronnen';
$string['lazyload_mod_page_description'] = 'Als deze optie is ingeschakeld, wordt de laadtijd van cursuspagina\'s aanzienlijk korter voor cursussen met veel pagina\'s.';
$string['pmadvancedfeed_viewmore'] = 'Bekijk meer';
$string['pmadvancedfeed_reload'] = 'Verversen';
$string['multimediacard'] = 'Multimediabestanden worden niet weergegeven in de activiteitkaartweergaven voor het Snap-thema. Dit wordt alleen toegepast op de startpagina en cursuspagina\'s voor kleine activiteit- en bronkaarten.';
$string['enabledlogin'] = 'Weergegeven aanmeldingsopties';
$string['enabledlogindesc'] = 'Selecteer de aanmeldingsopties die moeten worden weergegeven.';
$string['moodlelogin'] = 'Alleen Moodle-aanmelding weergeven';
$string['alternativelogin'] = 'Alleen alternatieve aanmeldingsopties weergeven';
$string['bothlogin'] = 'Beide aanmeldingsopties weergeven';
$string['enabledloginorder'] = 'Volgorde van aanmeldingsopties';
$string['enabledloginorderdesc'] = 'Selecteer welke aanmeldingsoptie als eerste moet worden weergegeven.';
$string['moodleloginfirst'] = 'Moodle-aanmelding als eerste weergeven';
$string['alternativeloginfirst'] = 'Alternatieve aanmeldingsopties als eerste weergeven';
$string['alternativeloginoptions'] = 'Alternatieve aanmeldingsopties';
$string['openmessagedrawer'] = 'Berichtenlade openen.';
$string['design_mod_page'] = 'Vorig ontwerp voor paginabronnen inschakelen';
$string['design_mod_page_description'] = 'Indien ingeschakeld wordt de paginabroninhoud op dezelfde pagina, in de cursus of op de beginpagina weergegeven.';
$string['design_activity_chooser'] = 'Terug naar het oorspronkelijke ontwerp voor de activiteitenkiezer';
$string['design_activity_chooser_description'] = 'Als deze optie is ingeschakeld, wordt de activiteitenkiezer weergegeven met het oorspronkelijke ontwerp. Dit heeft invloed op de cursus en de startpagina\'s.';
$string['refreshdeadlinestask'] = 'Vernieuwt de data van deadlines in de cache. Voer deze taak uit voordat alle gebruikers zich aanmelden.';
$string['refreshdeadlinestaskoff'] = 'Er is niet gezocht naar in te vullen gegevens. Schakel de instelling \'Deadlines verversen met geplande taak\' in de instellingen van het persoonlijke menu van Snap in, zodat deze taak de deadlines met gegevens in cache kan vullen.';
$string['activityrestriction'] = 'Beperking van activiteit';
$string['hideandshowactioncb'] = 'Selectievakje activiteit verbergen en weergeven';
