<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2021 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'このコースについて';
$string['activity'] = 'アクティビティ';
$string['action:changeassetvisibility'] = 'アセットの視認性をコントロールする';
$string['action:duplicateasset'] = 'アセットを複製する';
$string['action:changesectionvisibility'] = 'セクションの視認性をコントロールする';
$string['action:highlightsectionvisibility'] = 'セクションの可視性を強調表示する';
$string['action:sectiontoc'] = 'セクションの目次を取得する';
$string['addanewsection'] = '新しい問題を作成する ...';
$string['addresourceoractivity'] = '学習アクティビティを作成する';
$string['admin'] = '管理';
$string['advancedbrandingheading'] = '高度なブランディング';
$string['ago'] = '前';
$string['answered'] = '解答済み';
$string['appendices'] = 'ツール';
$string['assigndraft'] = '下書きには確認が必要です';
$string['assignreopened'] = '再オープン';
$string['at'] = '場所 :';
$string['attempted'] = '受験済み';
$string['basics'] = '基本';
$string['brandingheading'] = 'ブランディング';
$string['browse'] = '閲覧';
$string['browseallcourses'] = 'すべてのコースを参照する';
$string['cachedef_activity_deadlines'] = 'ユーザ活動期限のキャッシュストア';
$string['cachedef_generalstaticappcache'] = '一般的な静的アプリケーションレベルのキャッシュをスナップする';
$string['cachedef_course_completion_progress'] = 'これは完了データをコース/ユーザごとにキャッシュするために使用されます。';
$string['cachedef_course_completion_progress_ts'] = 'これは、コースまたはモジュールのコース完了設定が変更された場合にセッションレベルキャッシュを無効にするのに使用されます。';
$string['cachedef_webservicedefinitions'] = '自動生成されたウェブサービス定義のキャッシュ';
$string['card'] = 'カード';
$string['categoryedit'] = 'カテゴリを編集する';
$string['category_color'] = 'カテゴリの色';
$string['category_color_description'] = 'コースカテゴリの色。子コースは最も近い親カテゴリの設定を使用します';
$string['category_color_palette'] = 'カラーパレット';
$string['category_color_palette_description'] = '指定された色に対応する16進値を参照してください。これはすべての設定に影響を与えるわけではなく、ユーザが設定値を作成する上でのサンプルです。';
$string['changecoverimage'] = 'カバーイメージを変更する';
$string['changefullname'] = 'サイト名を変更する';
$string['chapters'] = '章';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'クローズ';
$string['conditional'] = '条件付き';
$string['contents'] = 'コンテンツ';
$string['contributed'] = '寄稿済み';
$string['courses'] = 'コース';
$string['coursecontacts'] = 'コース管理者';
$string['coursedisplay'] = 'コース表示';
$string['coursefootertoggle'] = 'コースフッタ';
$string['coursefootertoggledesc'] = 'コースフッタには、コース管理者、コース説明、コースでの最近のアクティビティなど、コースページのユーザに役立つ情報が表示されます。';
$string['courseformatnotification'] = '現在お使いのコース形式はSnapテーマでは完全にサポートされていません。Open LMSで最高のエクスペリエンスを実現するには、トピックまたは週次コースの形式をSnapテーマと共に使用することをお勧めします。コース形式は<a href="{$a}">コース設定</a>で変更できます。';
$string['coursefixydefaulttext'] = '現在どのコースにも登録されていません。<br>登録済みのコースはここに表示されます。';
$string['coursegrade'] = 'コース評定 :';
$string['coursepartialrender'] = 'コースセクションの遅延読み込みを有効にする';
$string['coursepartialrenderdesc'] = '有効にした場合、コースセクションの読み込みは、学生が選択したときにオンデマンドで行われます。これにより、コンテンツが大量にあるコースの読み込みが速くなります。';
$string['coursenavigation'] = 'コースナビゲーション';
$string['coursesummaryfilesunsuitable'] = 'カバーイメージを変更する前に、コース概要ファイルを空にしてください';
$string['coursetools'] = 'コースダッシュボード';
$string['coverdisplay'] = 'カバー表示';
$string['covercarousel'] = 'カバーカルーセル';
$string['covercarouselon'] = 'カバーカルーセルを使用する';
$string['covercarouseldescription'] = '<p>カルーセルは回転バナーのセット、またはスライドショーで、カバーイメージの代わりにサイトのホームページに表示されます。</p>
<p>最大3つの画像、各スライドのタイトル、オプションのサブタイトルを追加します。1200 x 600ピクセルの画像が最適です。</p>';
$string['coverimage'] = 'カバーイメージ';
$string['covervideo'] = 'カバービデオ';
$string['comingsoon'] = '準備中です！';
$string['createsection'] = 'セクションを作成する';
$string['current'] = '処理後';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = '大きな力には大きな責任が伴うことに注意してください。ここで追加されたCSSによって問題が生じた場合、あなたが解決する責任があります。Open LMSサポートはCSS関連のコンテンツに関してトラブルシューティングやヘルプを提供しません。';
$string['customtopbar'] = 'ナビゲーションバー';
$string['customisenavbar'] = 'ナビゲーションバーの色を変更する';
$string['customisenavbutton'] = '[マイコース]ボタンの色を変更する';
$string['customisecustommenu'] = 'カスタムメニューのテキストの色を変更する';
$string['custommenutext'] = 'カスタムメニューのテキストの色';
$string['deadlines'] = '期限';
$string['deadlinestoggle'] = '期限';
$string['deadlinestoggledesc'] = 'ユーザに対して、登録済みコースの今後の活動の終了日時が表示されます。';
$string['defaultsummary'] = 'この領域では、テキスト、画像、音声、動画を使用してこのトピックを説明します。';
$string['defaultintrosummary'] = '新しいコース {$a} へようこそ。
<br>テキスト、画像、音声、動画を使用して、コースについて説明します。';
$string['defaulttopictitle'] = '無題のトピック';
$string['debugerrors'] = 'デバッグエラー';
$string['deleteassetconfirm'] = '{$a} を削除する';
$string['deletingasset'] = '{$a} の削除';
$string['deletingassetname'] = '{$a->type} "{$a->name}"を削除中';
$string['deletesectionconfirm'] = 'セクションを削除する';
$string['deletingsection'] = 'セクション「 {$a} 」の削除中';
$string['draft'] = '学生には非公開';
$string['dropzonelabel'] = '添付するファイルをドロップ、または<span class="fake-link">参照</span>する';
$string['due'] = '期日 {$a}';
$string['edit'] = '"{$a}" を編集する';
$string['editcoursecontent'] = 'ブロックを編集する';
$string['editcoursesettings'] = 'コース設定';
$string['editcoursetopic'] = 'セクションを編集する';
$string['editcustomfooter'] = 'フッタを編集する';
$string['editcustommenu'] = 'カスタムメニューを編集する';
$string['error'] = 'エラー';
$string['errorgettingfeed'] = 'フィード項目の取得中にエラーが発生しました。';
$string['error:categorycolorinvalidjson'] = 'コースカテゴリのJSONフォーマットが正しくありません';
$string['error:categorycolorinvalidvalue'] = 'カテゴリ"{$a}"のレコードIDまたはカラー値が無効です';
$string['error:categorynotfound'] = 'ID"{$a}"のカテゴリレコードは見つかりませんでした';
$string['error:coverimageexceedsmaxbytes'] = 'カバーイメージがサイトレベルの最大許容ファイルサイズ ({$a}) を超えています。';
$string['error:coverimageresolutionlow'] = '最適な品質を得るためには、幅1024px以上の大きなイメージを推奨します。';
$string['error:duplicatedcategoryids'] = 'JSONフォーマットが正しくありません。いくつかのIDが重複しています';
$string['error:failedtochangeassetvisibility'] = 'アセットの表示/非表示に失敗しました';
$string['error:failedtochangesectionvisibility'] = 'セクションの表示/非表示に失敗しました';
$string['error:failedtohighlightsection'] = 'セクションの強調表示に失敗しました';
$string['error:failedtoduplicateasset'] = '複製に失敗しました';
$string['error:failedtodeleteasset'] = 'アセットの削除に失敗しました';
$string['error:failedtotoc'] = 'TOCの取得に失敗しました。';
$string['extension'] = '拡張子 {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'あなたのFacebookページのURL。';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'FaviconはWebブラウザのアドレスバー、ユーザのブックマーク、モバイルショートカットに表示されます。';
$string['favorite'] = 'お気に入り {$a}';
$string['favorited'] = 'お気に入りとしてマーク {$a}';
$string['featurespots'] = '注目スポット';
$string['featurespotsedit'] = '注目スポットを編集する';
$string['featurespotshelp'] = '<p>既存および潜在的ユーザに主なメリットを強調するため、サイトのフロントページに最大3つの注目スポットを強調表示します。</p>
<p>それぞれの注目スポットのタイトル、内容、オプションの画像を追加します。画像は四角形で、サイズは最大200px x 200pxとします。</p>';
$string['featurespotsheading'] = '注目スポットのヘッダ';
$string['featureonetitle'] = '注目スポット1のタイトル';
$string['featuretwotitle'] = '注目スポット2のタイトル';
$string['featurethreetitle'] = '注目スポット3のタイトル';
$string['featureonetitlelink'] = '注目スポット1のタイトルのリンク';
$string['featuretwotitlelink'] = '注目スポット2のタイトルのリンク';
$string['featurethreetitlelink'] = '注目スポット3のタイトルのリンク';
$string['featuretitlelinkdesc'] = 'この注目スポットをリンクするURLを入力します。サイト内に外部または内部のリンクを追加できます。内部リンクを追加する場合は、サイトURLから「/」を含めてコピーしてください。たとえば、コースへのリンクの場合、「/course/view.php?id=160」のようになります。外部リンクを追加する場合は、リンクをhttps://で開始します。';
$string['featureonetitlecb'] = '注目スポット1を新しいウィンドウで開く';
$string['featuretwotitlecb'] = '注目スポット2を新しいウィンドウで開く';
$string['featurethreetitlecb'] = '注目スポット3を新しいウィンドウで開く';
$string['featuretitlecbdesc'] = '有効にすると、注目スポットに追加されたリンクは新しいウィンドウで開かれます。';
$string['featureonetext'] = '注目スポット1の内容';
$string['featuretwotext'] = '注目スポット2の内容';
$string['featurethreetext'] = '注目スポット3の内容';
$string['featureoneimage'] = '注目スポット1のイメージ';
$string['featuretwoimage'] = '注目スポット2のイメージ';
$string['featurethreeimage'] = '注目スポット3のイメージ';
$string['featuredcourses'] = '注目コース';
$string['featuredcourseshelp'] = 'サイトのフロントページに最大8つの注目コースを強調表示します。強調表示するコースのコースIDを入力してください。';
$string['featuredcoursesheading'] = '注目コースのヘッダ';
$string['featuredcourseone'] = '注目コース1';
$string['featuredcoursetwo'] = '注目コース2';
$string['featuredcoursethree'] = '注目コース3';
$string['featuredcoursefour'] = '注目コース4';
$string['featuredcoursefive'] = '注目コース5';
$string['featuredcoursesix'] = '注目コース6';
$string['featuredcourseseven'] = '注目コース7';
$string['featuredcourseeight'] = '注目コース8';
$string['featuredcoursesedit'] = '注目コースを編集する';
$string['featuredcoursesbrowseall'] = 'すべてのコースを参照する';
$string['featuredcoursesbrowsealldesc'] = 'すべてのコースを参照するリンクを追加';
$string['feedbackavailable'] = 'フィードバックを利用できます';
$string['feedbacktoggle'] = '最新のフィードバック';
$string['feedbacktoggledesc'] = '学習者に最新のフィードバックを、教育者に最新の提出物で要評定のものを表示します。';
$string['footnote'] = 'サイトフッタ';
$string['footnotedesc'] = 'フッタはサイト全体にわたって表示されます。ヘルプ、サポート、および学習者や教育者と共有したい組織所有のその他のサイト (ライブラリやメールアドレスなど) へのリンクを配置するのに最適な場所です。';
$string['forcepwdwarningpersonalmenu'] = 'パーソナルメニューを使用する前に、<a href="{$a}">パスワードを変更する</a>必要があります。';
$string['forumauthor'] = '著者';
$string['forumlastpost'] = '最新の投稿';
$string['forumpicturegroup'] = 'グループ';
$string['forumreplies'] = '返信';
$string['forumtopic'] = 'トピック';
$string['forumposts'] = 'フォーラム投稿';
$string['forumpoststoggle'] = 'フォーラム投稿';
$string['forumpoststoggledesc'] = 'コースで最新10件のフォーラム投稿が表示されます。';
$string['fullname'] = 'サイト名';
$string['fullnamedesc'] = 'サイトの名前です。';
$string['graderadviseuserreport'] = '"評定者レポート"は、モバイルデバイスでは適切に機能しません。代わりに"ユーザレポート"を使用することをお勧めします';
$string['grading'] = '採点';
$string['help'] = 'ヘルプ';
$string['helpguide'] = 'ヘルプガイド';
$string['headingfont'] = '見出しのフォント';
$string['headingfont_desc'] = 'このフォントは、サイト全体の見出し (h1 - h6要素) で使用されます。カスタムWebフォントを含めている場合は、必ずMoodleの特別HTMLフォームに追加してください。';
$string['helpwithlogin'] = 'ログインのヘルプ';
$string['helpwithloginandguest'] = 'ログイン/ゲストアクセスのヘルプ';
$string['hiddencoursestoggle'] = '非表示のコース';
$string['highlightedsection'] = '反転表示';
$string['home'] = 'ホーム';
$string['image'] = 'イメージ';
$string['images'] = 'イメージ';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'あなたのInstagramアカウントのURLです。';
$string['introduction'] = 'イントロダクション';
$string['jsontext'] = 'JSONテキスト';
$string['jsontextdescription'] = 'テキストエリアは指定されたJSONを検証するため、既存のカテゴリのみが許可され、IDレコード (カテゴリレコード) としての数値のみが有効で、16進値のみを色として受け付けます。
以下に例を示します。<br>
{"1":"#FAAFFF",<br>
"45":"#AFF",<br>
"65":"#FFF228",<br>
"12":"#CC0084",<br>
"56":"#CC0087",<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Open LMSナレッジベース';
$string['list'] = '一覧から選ぶ';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'あなたの組織のLinkedInのURLです。';
$string['leftnav'] = '目次';
$string['leftnavdesc'] = '目次を表示する場所を選択します。リストの方が多くの目次を表示でき、トピックの多いコースに適しています。';
$string['loading'] = 'ロード中...';
$string['loggedinasguest'] = 'ゲストとしてログインしています';
$string['loggedoutmsg'] = 'あなたは現在ログアウトしています。引き続きこのサイトを使用するには、ログインしてください。';
$string['loggedoutmsgtitle'] = 'ログアウトされました';
$string['loggedoutfailmsg'] = '{$a}にログインする必要があります。';
$string['loginform'] = 'ログイン';
$string['logo'] = 'ロゴ';
$string['logodesc'] = 'ロゴはサイト全体にわたってヘッダに表示されます。';
$string['menu'] = 'マイコース';
$string['messageread'] = '既読メッセージ';
$string['messages'] = 'メッセージ';
$string['messagestoggle'] = 'メッセージ';
$string['messagestoggledesc'] = '過去12週に受信した最新メッセージが表示されます。';
$string['more'] = '詳細';
$string['morenews'] = 'その他のニュース';
$string['movingstartedhelp'] = 'セクション "{$a}" を配置したい場所に移動します';
$string['movingdropsectionhelp'] = 'セクション "{$a->moving}" をセクション "{$a->before}" の前に配置します';
$string['moving'] = '"{$a}" を移動しています';
$string['movingcount'] = '{$a} オブジェクトを移動しています';
$string['movefailed'] = '"{$a}" の移動に失敗しました';
$string['move'] = '"{$a}" を移動する';
$string['movehere'] = 'ここに移動する';
$string['movesection'] = 'セクションを移動する';
$string['navbarbg'] = '背景色';
$string['navbarlink'] = '文字色';
$string['navbarbuttoncolor'] = '背景色';
$string['navbarbuttonlink'] = '文字色';
$string['nextsection'] = '次のセクション';
$string['nodeadlines'] = '予定されている終了日時はありません。';
$string['noforumposts'] = '関連するフォーラム投稿はありません。';
$string['nograded'] = '最新のフィードバックはありません。';
$string['nograding'] = '採点すべき提出課題はありません。';
$string['nomessages'] = 'メッセージはありません。';
$string['notanswered'] = '未解答';
$string['notattempted'] = '未受験';
$string['notcontributed'] = '未寄稿';
$string['notpublished'] = '学生には非公開';
$string['notsubmitted'] = '未提出';
$string['overdue'] = '期限切れ';
$string['personalmenu'] = 'パーソナルメニュー';
$string['personalmenufeatures'] = 'パーソナルメニュー機能';
$string['personalmenulogintoggle'] = 'ログイン時に個人用メニューを表示する';
$string['personalmenulogintoggledesc'] = 'ログイン後は個人用メニューを開く';
$string['personalmenuadvancedfeedsenable'] = '高度なフィードを有効にする';
$string['personalmenuadvancedfeedsenabledesc'] = '高度なフィードでは、読み込み時間の高速化を可能にし、コンテンツをオンデマンドでリフレッシュする、個人的なメニュー項目が読み込みまれます。';
$string['personalmenuadvancedfeedsperpage'] = '高度なフィード項目の表示数';
$string['personalmenuadvancedfeedsperpagedesc'] = 'フィードで表示する項目の数を選択します。ユーザは[<strong>さらに表示</strong>]を選択して追加項目を表示できます。';
$string['personalmenuadvancedfeedslifetime'] = '高度なフィードの有効期間';
$string['personalmenuadvancedfeedslifetimedesc'] = 'ログイン後にフィードがブラウザにキャッシュされる時間を選択します。0を選択するとフィードはブラウザにキャッシュされません。';
$string['personalmenurefreshdeadlines'] = 'スケジュールタスクを使用して終了日時をリフレッシュします。';
$string['personalmenurefreshdeadlinesdesc'] = 'タスクを実行したときに、終了日時データはより速いページロード時間でリフレッシュされます。';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'カバーイメージ';
$string['posterdesc'] = 'サイトのフロントページ用の大きいヘッダイメージです。横向きイメージ (1200 x 600ピクセル) 以上が最適です。';
$string['poweredbyrunby'] = '<a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
a <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>ベースの製品) で構築しています。<br>
Copyright &#169; {$a->year} Open LMS, All Rights Reserved.';
$string['previoussection'] = '前のセクション';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'ユーザがお気に入りとしてマークしたコースのコースID';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'コースをお気に入りにマークしたユーザのユーザID';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'ユーザがコースをお気に入りとしてマークしたときのタイムスタンプ';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Snapのユーザのコースのお気に入りを保存します';
$string['problemsfound'] = '問題が見つかりました。';
$string['progress'] = '進捗';
$string['readmore'] = '詳細情報&nbsp;»';
$string['recentactivity'] = '最近の活動';
$string['recentfeedback'] = 'フィードバック';
$string['region-main'] = 'メイン';
$string['region-side-main-box'] = 'メイン';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['region-side-top'] = '上揃え';
$string['released'] = 'リリース済み : {$a}';
$string['reopened'] = '再オープン';
$string['resourcedisplay'] = 'リソース表示';
$string['resourcedisplayhelp'] = '添付ファイルとリンクをコースにどのように表示するか選択します。Snapテーマでは、小さいアクティビティとリソースカードの説明にあるマルチメディアファイルをサポートしていません。';
$string['displaydescription'] = '説明を表示する';
$string['displaydescriptionhelp'] = '選択すると、最初に新しいページにリソースとURLアクティビティの説明が表示されます。学生は、説明からコンテンツにアクセスします。';
$string['search'] = 'コンテンツを検索する';
$string['seriffont'] = 'Serifフォント';
$string['seriffont_desc'] = 'このフォントは、ユーザが生成するコンテンツのほとんどに使用されます。Serifフォントを使用すると、コンテンツの読みやすさが増し、人間が書いたもののようになります。';
$string['showcoursegradepersonalmenu'] = '成績';
$string['showcoursegradepersonalmenudesc'] = 'パーソナルメニューのコースカードにユーザの評定を表示します';
$string['socialmedia'] = 'ソーシャルメディア';
$string['submitted'] = '提出済み';
$string['sitedescription'] = 'サイト説明';
$string['subtitle'] = 'サブタイトル';
$string['subtitle_desc'] = 'サイトについてユーザに簡単に説明します。';
$string['themecolor'] = 'サイトの色';
$string['themecolordesc'] = '明るい色が最適です。サイトがモダンな印象になります。';
$string['title'] = 'タイトル';
$string['top'] = '上揃え';
$string['topbarbgcolor'] = 'ナビゲーションバーの色';
$string['topbarlinkcolor'] = 'ナビゲーションバーのリンクとアイコンの色';
$string['topbarbuttoncolor'] = 'マイコースの背景';
$string['togglenavigation'] = 'ナビゲーションに切り替える';
$string['topicactions'] = 'トピックアクション';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'あなたのTwitterアカウントのURLです。';
$string['unenrolme'] = '登録抹消する';
$string['enrolme'] = '受講登録する';
$string['unread'] = '未読';
$string['unsupportedcoverimagetype'] = 'サポートされていないカバーイメージタイプ ({$a}) です';
$string['via'] = '方法 :';
$string['viewcourse'] = 'コースを表示する';
$string['viewmore'] = 'さらに表示する';
$string['viewyourprofile'] = 'プロファイルを表示する';
$string['viewmyfeedback'] = '私のフィードバックを表示する';
$string['viewcalendar'] = '私の予定表を表示する';
$string['viewforumposts'] = '私のフォーラム投稿を表示する';
$string['viewmessaging'] = '私のメッセージを表示する';
$string['vieworiginalimage'] = '元のイメージを表示する';
$string['visibility'] = '表示';
$string['xofyanswered'] = '{$a->completed} / {$a->participants} 解答済み';
$string['xofyattempted'] = '{$a->completed} / {$a->participants} 受験済み';
$string['xofycontributed'] = '{$a->completed} / {$a->participants} 寄稿済み';
$string['xofysubmitted'] = '{$a->completed} / {$a->participants} 提出済み';
$string['xungraded'] = '{$a} 未採点';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'あなたのYouTubeチャンネルのURLです。';
$string['showallsectionsdisabled'] = 'デザイン言語のため、Snapでは「1ページにすべてのセクションを表示する」は利用できません。';
$string['disabled'] = '無効にされています';
$string['showappearancedisabled'] = 'Snapの設計言語は"アピアランス"設定の変更を防ぎます。';
$string['pbb'] = 'プロファイルベースのブランディング';
$string['pbb_description'] = '<strong>プロファイルベースのブランディング</strong>を有効にすると、選択したユーザプロファイルフィールドに基づいて、特定のユーザグループのブランディング体験をカスタマイズすることができます。
<ul><li>ユーザフィールド値は<em>スラッグ化され</em>て、すべての文字が小文字に変換され、それぞれがダッシュ (-) で区切られます</li>
<li>文字列「<code>snap-pbb-</code>」が先頭に追加されます</li>
<li>このクラスは<code>body</code> HTMLタグに追加されます</li></ul>
たとえば、ユーザフィールド値<em>Blueberry Extravaganza</em>はスラッグ化されて次のように変換されます : <code>snap-pbb-blueberry-extravaganza</code><br /><br />
この機能は<a href="https://help.blackboard.com/Blackboard_Open_LMS/Administrator/Manage_a_Site/Course_and_Site_Design/Themes/Snap#advanced-branding_OTP-3" target="_blank">Custom CSS</a>と組み合わせて使用され、
<a class="snap-settings-tab-link" href="#themesnapbranding">基本</a>セクションの新しいクラスを使用してCSSセレクタを追加する必要があります。';
$string['pbb_enable'] = 'プロファイルベースのブランディングを有効にする';
$string['pbb_enable_description'] = 'アクティブな場合、bodyタグへのクラスの追加のみ行います。';
$string['pbb_field'] = '使用するユーザフィールド';
$string['pbb_field_description'] = 'このフィールドの値はスラッグ化され、<code>snap-pbb-</code>が先頭に追加されたCSSクラス名として使用されます。';
$string['cachedef_profile_based_branding'] = 'プロファイルベースのブランディングのキャッシング。';
$string['cachedef_course_card_bg_image'] = 'コースの背景イメージのキャッシング。';
$string['cachedef_course_card_teacher_avatar'] = '教師のアバターのキャッシング。';
$string['cachedef_course_card_teacher_avatar_index'] = '教師のアバターのインデックスのキャッシング。';
$string['accessforumstringdis'] = '表示オプション';
$string['accessforumstringmov'] = '移動オプション';
$string['accesscalendarstring'] = 'カレンダー';
$string['accessglobalsearchstring'] = '検索';
$string['admineventwarning'] = 'すべてのコースのイベントを見るには、';
$string['gotocalendarsnap'] = 'サイトカレンダーに移動します。';
$string['quizattemptswarn'] = '一時停止ユーザの受験を除外する';
$string['quizfeedback'] = 'フィードバック';
$string['validratio'] = 'この色の組み合わせは、WCAG 2.0の最小比率値4.5:1に準拠しています';
$string['invalidratio'] = 'この色の組み合わせは、
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0の最小比率値4.5:1</a>に準拠していません。値 : 「{$a}」';
$string['imageinvalidratio'] = 'このイメージは、WCAG 2.0の最小比率値4.5:1に準拠していないため、コントラストに問題がある可能性があります。平均ピクセル値 : 「{$a}」';
$string['catinvalidratio'] = '以下の色のカテゴリは、
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0の最小比率値4.5:1</a>に準拠していません :
サイトの背景色 (白) に対して : 「{$a->white}」。ナビゲーションバーの背景色に対して : 「{$a->custombar}」。[マイコース]ボタンの背景色に対して : 「{$a->customnav}」';
$string['imageinvalidratiocategory'] = 'このイメージは、WCAG 2.0最小比率値4.5:1に準拠していないため、テーマの色とのコントラストに問題がある可能性があります。平均ピクセル値 : 「{$a}」';
$string['lazyload_mod_page'] = 'ページリソースのデフォルトの遅延読み込みを有効にする';
$string['lazyload_mod_page_description'] = '有効にした場合、この設定は、大量のページがあるコースページの読み込み時間を大幅に短縮します。';
$string['pmadvancedfeed_viewmore'] = 'さらに表示する';
$string['pmadvancedfeed_reload'] = 'リフレッシュ';
$string['multimediacard'] = 'マルチメディアファイルは、Snapテーマのアクティビティカード表示では表示されません。これは小さいアクティビティとリソースカードのホームページとコースページにのみ適用されます。';
$string['enabledlogin'] = '表示するログインオプション';
$string['enabledlogindesc'] = '表示する必要があるログインオプションを選択します。';
$string['moodlelogin'] = 'Moodleログインのみ表示';
$string['alternativelogin'] = '代替ログインオプションのみ表示';
$string['bothlogin'] = '両方のログインオプションを表示';
$string['enabledloginorder'] = 'ログインオプションの順番';
$string['enabledloginorderdesc'] = '最初に表示するログインオプションを選択します。';
$string['moodleloginfirst'] = '最初にMoodleログインを表示する';
$string['alternativeloginfirst'] = '最初に代替ログインオプションを表示する';
$string['alternativeloginoptions'] = '代替ログインオプション';
$string['openmessagedrawer'] = 'メッセージングドロワーを開きます。';
$string['design_mod_page'] = 'ページリソースの以前のデザインを有効にする';
$string['design_mod_page_description'] = '有効にすると、ページリソースのコンテンツが、同じページ、コース、またはフロントページに表示されます。';
$string['design_activity_chooser'] = '活動チューザのオリジナルのデザインにロールバックする';
$string['design_activity_chooser_description'] = '有効にすると、活動チューザがオリジナルのデザインで表示されます。これは、コースとフロントページに影響を与えます。';
$string['refreshdeadlinestask'] = '終了日時のキャッシュされたデータをリフレッシュします。これはすべてのユーザがログインする前に実行される必要があります。';
$string['refreshdeadlinestaskoff'] = '投入するデータを検索しませんでした。Snapの個人メニュー設定の「スケジュール済みタスクを使用して期限をリフレッシュ」設定をオンにし、このタスクが期限キャッシュデータを投入できるようにします。';
$string['activityrestriction'] = 'アクティビティの制限';
$string['hideandshowactioncb'] = 'アクティビティのチェックボックスアクションを非表示および表示します';
