<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2021 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'À propos de ce cours';
$string['activity'] = 'Activité';
$string['action:changeassetvisibility'] = 'modifier la visibilité des ressources';
$string['action:duplicateasset'] = 'dupliquer la ressource';
$string['action:changesectionvisibility'] = 'modifier la visibilité des sections';
$string['action:highlightsectionvisibility'] = 'mettre en surbrillance la visibilité des sections';
$string['action:sectiontoc'] = 'obtenir la table des matières de section';
$string['addanewsection'] = 'Créer une section';
$string['addresourceoractivity'] = 'Créer une activité d\'apprentissage';
$string['admin'] = 'Admin';
$string['advancedbrandingheading'] = 'Personnalisation avancée';
$string['ago'] = 'Il y a';
$string['answered'] = 'Répondu';
$string['appendices'] = 'Outils';
$string['assigndraft'] = 'Brouillon nécessitant votre confirmation';
$string['assignreopened'] = 'Réouvert';
$string['at'] = 'à';
$string['attempted'] = 'Tentative effectuée';
$string['basics'] = 'Essentiel';
$string['brandingheading'] = 'Personnalisation';
$string['browse'] = 'parcourir';
$string['browseallcourses'] = 'Parcourir tous les cours';
$string['cachedef_activity_deadlines'] = 'Entrepôt de cache des échéances des activités d\'un utilisateur.';
$string['cachedef_generalstaticappcache'] = 'Cache Snap statique général au niveau de l\'application';
$string['cachedef_course_completion_progress'] = 'Ceci est utilisé pour mettre en cache les données d\'achèvement par cours/utilisateur.';
$string['cachedef_course_completion_progress_ts'] = 'Ceci est utilisé pour que nous puissions invalider les caches au niveau des sessions si les paramètres d\'achèvement changent pour un cours ou un module.';
$string['cachedef_webservicedefinitions'] = 'Mise en cache des définitions de service Web générées automatiquement.';
$string['card'] = 'Carte';
$string['categoryedit'] = 'Modifier une catégorie';
$string['category_color'] = 'Couleur de la catégorie';
$string['category_color_description'] = 'Couleur de la catégorie du cours. Les cours enfants adoptent la configuration de la catégorie du parent le plus proche';
$string['category_color_palette'] = 'Palette de couleurs';
$string['category_color_palette_description'] = 'Examinez la valeur hexadécimale correspondante pour la couleur considérée. Aucune configuration n\'est affectée, il s\'agit simplement d\'un échantillon aidant les utilisateurs à générer la valeur de configuration.';
$string['changecoverimage'] = 'Modifier l\'image de couverture';
$string['changefullname'] = 'Modifier nom du site';
$string['chapters'] = 'Chapitres';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Fermer';
$string['conditional'] = 'Conditionnel';
$string['contents'] = 'Contenus';
$string['contributed'] = 'Contribution apportée';
$string['courses'] = 'Cours';
$string['coursecontacts'] = 'Contacts de cours';
$string['coursedisplay'] = 'Affichage du cours';
$string['coursefootertoggle'] = 'Pied de page du cours';
$string['coursefootertoggledesc'] = 'Le pied de page de cours affiche des informations utiles pour les utilisateurs sur une page de cours, notamment les contacts de cours, la description du cours et l\'activité récente dans le cours.';
$string['courseformatnotification'] = 'Le format de cours que vous utilisez actuellement n\'est pas totalement pris en charge par le thème Snap. Open LMS recommande d\'utiliser les formats de cours Hebdomadaire et Rubrique avec le thème Snap pour bénéficier de la meilleure expérience. Le format de cours peut être modifié dans les <a href="{$a}">réglages du cours</a>.';
$string['coursefixydefaulttext'] = 'Vous n\'êtes inscrit à aucun cours actuellement.<br>Les cours auxquels vous êtes inscrit sont affichés ici.';
$string['coursegrade'] = 'Note du cours :';
$string['coursepartialrender'] = 'Activer le chargement différé des sections de cours';
$string['coursepartialrenderdesc'] = 'Si ce paramètre est activé, les sections de cours sont chargées lorsque l\'utilisateur les sélectionne. Cela permet de charger les cours volumineux plus rapidement.';
$string['coursenavigation'] = 'Navigation de cours';
$string['coursesummaryfilesunsuitable'] = 'Videz vos fichiers de cours avant de tenter de modifier l\'image de couverture';
$string['coursetools'] = 'Tableau de bord du cours';
$string['coverdisplay'] = 'Affichage de la couverture';
$string['covercarousel'] = 'Carrousel de couverture';
$string['covercarouselon'] = 'Utiliser le carrousel de couverture';
$string['covercarouseldescription'] = '<p>Le carrousel est un ensemble de bannières rotatives, ou diaporama, qui s\'affiche sur la page d\'accueil de votre site à la place de l\'image de couverture.</p>
<p>Ajoutez jusqu\'à 3 images, un titre pour chaque diapositive et un sous-titre facultatif. La résolution optimale des images est de 1200 x 600 pixels.</p>';
$string['coverimage'] = 'Image de couverture';
$string['covervideo'] = 'Vidéo de couverture';
$string['comingsoon'] = 'Bientôt disponible !';
$string['createsection'] = 'Créer une section';
$string['current'] = 'Actuelle';
$string['customcss'] = 'CSS personnalisé';
$string['customcssdesc'] = 'Vous êtes responsable des actions que vous exécutez. Il vous incombera de résoudre tout problème causé par le code CSS ajouté ici. L\'assistance Open LMS ne fournit aucun dépannage ni aucune aide concernant le contenu CSS.';
$string['customtopbar'] = 'Barre de navigation';
$string['customisenavbar'] = 'Modifier les couleurs de la barre de navigation';
$string['customisenavbutton'] = 'Modifier les couleurs du bouton Mes cours';
$string['customisecustommenu'] = 'Modifier la couleur du texte du menu personnalisé';
$string['custommenutext'] = 'Couleur du texte du menu personnalisé';
$string['deadlines'] = 'Échéance';
$string['deadlinestoggle'] = 'Échéance';
$string['deadlinestoggledesc'] = 'Montrer aux utilisateurs les échéances des activités à venir des cours auxquels ils sont inscrits.';
$string['defaultsummary'] = 'Utilisez cette zone pour décrire le thème de cette rubrique. Vous pouvez insérer du texte, des images, ainsi que des contenus audio et vidéo.';
$string['defaultintrosummary'] = 'Bienvenue dans votre nouveau cours {$a}.
<br>Commencez par décrire le thème de votre cours à l\'aide de texte, d\'images, ainsi que de contenus audio et vidéo.';
$string['defaulttopictitle'] = 'Rubrique sans titre';
$string['debugerrors'] = 'Erreurs de débogage';
$string['deleteassetconfirm'] = 'Supprimer {$a}';
$string['deletingasset'] = 'Suppression de l\'élément {$a}';
$string['deletingassetname'] = 'Suppression de l\'élément {$a->type} "{$a->name}"';
$string['deletesectionconfirm'] = 'Supprimer la section';
$string['deletingsection'] = 'Suppression de la section "{$a}"';
$string['draft'] = 'Non publié pour les étudiants';
$string['dropzonelabel'] = 'Faites-glisser les fichiers à attacher ou <span class="fake-link">recherchez-les</span>';
$string['due'] = 'À rendre le {$a}';
$string['edit'] = 'Modifier "{$a}"';
$string['editcoursecontent'] = 'Modifier les blocs';
$string['editcoursesettings'] = 'Paramètres de cours';
$string['editcoursetopic'] = 'Modifier la section';
$string['editcustomfooter'] = 'Modifier le pied de page';
$string['editcustommenu'] = 'Modifier le menu personnalisé';
$string['error'] = 'Erreur';
$string['errorgettingfeed'] = 'Une erreur est survenue lors de l\'obtention des éléments de flux.';
$string['error:categorycolorinvalidjson'] = 'Format JSON incorrect pour les catégories de cours';
$string['error:categorycolorinvalidvalue'] = 'L\'identifiant d\'enregistrement ou la valeur de couleur pour la catégorie "{$a}" ne sont pas valides.';
$string['error:categorynotfound'] = 'L\'enregistrement de catégorie associé à l\'identifiant "{$a}" n\'a pas été trouvé';
$string['error:coverimageexceedsmaxbytes'] = 'L\'image de couverture dépasse la taille maximale de fichier autorisée au niveau du site ({$a})';
$string['error:coverimageresolutionlow'] = 'Pour une qualité optimale, nous recommandons de choisir une image plus grande d\'une largeur d\'au moins 1024 px.';
$string['error:duplicatedcategoryids'] = 'Format JSON incorrect, certains identifiants ont été dupliqués';
$string['error:failedtochangeassetvisibility'] = 'Échec de l\'action Masquer/Afficher sur la ressource';
$string['error:failedtochangesectionvisibility'] = 'Échec de l\'action Masquer/Afficher sur la section';
$string['error:failedtohighlightsection'] = 'Échec de la mise en surbrillance de la section';
$string['error:failedtoduplicateasset'] = 'Échec de la duplication';
$string['error:failedtodeleteasset'] = 'Impossible de supprimer la ressource';
$string['error:failedtotoc'] = 'Impossible d\'obtenir la table des matières.';
$string['extension'] = 'Extension {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'URL de votre page Facebook.';
$string['favicon'] = 'Icône de favori';
$string['favicondesc'] = 'Les icônes de favori apparaissent dans la barre d\'adresse de votre navigateur Web, dans les marque-pages de l\'utilisateur et dans les raccourcis mobiles.';
$string['favorite'] = 'Favori {$a}';
$string['favorited'] = 'Ajouté aux favoris {$a}';
$string['featurespots'] = 'Emplacements de fonctionnalités';
$string['featurespotsedit'] = 'Modifier les emplacements de fonctionnalités';
$string['featurespotshelp'] = '<p>Ajoutez jusqu\'à 3 emplacements de fonctionnalités à la page d\'accueil de votre site pour mettre en évidence les avantages principaux pour les utilisateurs actifs et potentiels.</p>
<p>Ajoutez un titre, du contenu et une image facultative pour chaque fonctionnalité. Les images doivent être carrées et leur taille ne doit pas dépasser 200 x 200 px.</p>';
$string['featurespotsheading'] = 'Titre des emplacements de fonctionnalités';
$string['featureonetitle'] = 'Titre de la fonctionnalité 1';
$string['featuretwotitle'] = 'Titre de la fonctionnalité 2';
$string['featurethreetitle'] = 'Titre de la fonctionnalité 3';
$string['featureonetitlelink'] = 'Lien du titre de la fonctionnalité 1';
$string['featuretwotitlelink'] = 'Lien du titre de la fonctionnalité 2';
$string['featurethreetitlelink'] = 'Lien du titre de la fonctionnalité 3';
$string['featuretitlelinkdesc'] = 'Saisissez l\'URL à laquelle vous souhaitez lier cet emplacement de fonctionnalité. Vous pouvez ajouter des liens externes et internes sur votre site. Pour ajouter un lien externe, copiez-le à partir de l\'URL du site en incluant la barre oblique (« / »). Par exemple, pour ajouter un lien vers un cours, copiez « /course/view.php?id=160 ». Pour ajouter un lien externe, le lien doit commencer par https://';
$string['featureonetitlecb'] = 'La fonctionnalité 1 s\'ouvre dans une nouvelle fenêtre';
$string['featuretwotitlecb'] = 'La fonctionnalité 2 s\'ouvre dans une nouvelle fenêtre';
$string['featurethreetitlecb'] = 'La fonctionnalité 3 s\'ouvre dans une nouvelle fenêtre';
$string['featuretitlecbdesc'] = 'Lorsque cette option est activée, le lien ajouté à l\'emplacement de fonctionnalité s\'ouvre dans une nouvelle fenêtre';
$string['featureonetext'] = 'Contenu de la fonctionnalité 1';
$string['featuretwotext'] = 'Contenu de la fonctionnalité 2';
$string['featurethreetext'] = 'Contenu de la fonctionnalité 3';
$string['featureoneimage'] = 'Image de la fonctionnalité 1';
$string['featuretwoimage'] = 'Image de la fonctionnalité 2';
$string['featurethreeimage'] = 'Image de la fonctionnalité 3';
$string['featuredcourses'] = 'Cours mis en avant';
$string['featuredcourseshelp'] = 'Mettez en avant jusqu\'à 8 cours sur la page d\'accueil de votre site. Saisissez l\'identifiant de cours pour mettre en avant un cours.';
$string['featuredcoursesheading'] = 'Titre du cours mis en avant';
$string['featuredcourseone'] = 'Cours mis en avant 1';
$string['featuredcoursetwo'] = 'Cours mis en avant 2';
$string['featuredcoursethree'] = 'Cours mis en avant 3';
$string['featuredcoursefour'] = 'Cours mis en avant 4';
$string['featuredcoursefive'] = 'Cours mis en avant 5';
$string['featuredcoursesix'] = 'Cours mis en avant 6';
$string['featuredcourseseven'] = 'Cours mis en avant 7';
$string['featuredcourseeight'] = 'Cours mis en avant 8';
$string['featuredcoursesedit'] = 'Modifier les cours mis en avant';
$string['featuredcoursesbrowseall'] = 'Parcourir tous les cours';
$string['featuredcoursesbrowsealldesc'] = 'Ajouter un lien Parcourir tous les cours';
$string['feedbackavailable'] = 'Feed-back disponible';
$string['feedbacktoggle'] = 'Feed-back et notation';
$string['feedbacktoggledesc'] = 'Montrez aux élèves leurs feed-backs les plus récents, et aux formateurs les travaux remis les plus récents devant être notés.';
$string['footnote'] = 'Pied de page du site';
$string['footnotedesc'] = 'Votre pied de page est affiché sur tout le site. Il s\'agit du meilleur emplacement pour placer des liens vers l\'aide, l\'assistance et tout autre site de votre organisation que vous souhaitez faire connaître aux apprenants et aux formateurs. Par exemple, la bibliothèque ou une adresse électronique, etc.';
$string['forcepwdwarningpersonalmenu'] = 'Vous devez <a href="{$a}">changer votre mot de passe</a> avant d\'utiliser le menu personnel.';
$string['forumauthor'] = 'Auteur';
$string['forumlastpost'] = 'Dernier message';
$string['forumpicturegroup'] = 'Groupe';
$string['forumreplies'] = 'Réponses';
$string['forumtopic'] = 'Rubrique';
$string['forumposts'] = 'Messages de forum';
$string['forumpoststoggle'] = 'Messages de forum';
$string['forumpoststoggledesc'] = 'Montrer aux utilisateurs les 10 messages de forum les plus récents provenant de leurs cours';
$string['fullname'] = 'Nom du site';
$string['fullnamedesc'] = 'Nom de votre site.';
$string['graderadviseuserreport'] = 'Le "rapport de l\'évaluateur" ne fonctionne pas de façon optimale sur les appareils mobiles. Utilisez le "rapport de l\'utilisateur" à la place';
$string['grading'] = 'Évaluation';
$string['help'] = 'Aide';
$string['helpguide'] = 'Guide d\'aide';
$string['headingfont'] = 'Police de titre';
$string['headingfont_desc'] = 'Cette police est utilisée dans les titres (éléments T1-T6) sur l\'ensemble de votre site. Si vous ajoutez une police Web personnalisée, n\'oubliez pas de l\'ajouter au formulaire HTML supplémentaire de Moodle.';
$string['helpwithlogin'] = 'Aide à la connexion';
$string['helpwithloginandguest'] = 'Aide à la connexion/l\'accès anonyme';
$string['hiddencoursestoggle'] = 'Cours masqués';
$string['highlightedsection'] = 'mis en surbrillance';
$string['home'] = 'accueil';
$string['image'] = 'image';
$string['images'] = 'Images';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'URL de votre compte Instagram.';
$string['introduction'] = 'Introduction';
$string['jsontext'] = 'Texte JSON';
$string['jsontextdescription'] = 'La zone de texte valide le texte JSON considéré, de manière à ce qu\'uniquement les catégories existantes soient autorisées, à ce que les valeurs numériques sous forme d\'enregistrements d\'identifiants (enregistrements de catégories) soient les seuls éléments valides et que seules les valeurs hexadécimales soient acceptées en tant que couleurs. Voici un exemple : <br>
{"1":"#FAAFFF",<br>
"45":"#AFF",<br>
"65":"#FFF228",<br>
"12":"#CC0084",<br>
"56":"#CC0087",<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Base de connaissances Open LMS';
$string['list'] = 'Liste';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'URL de la page LinkedIn de votre organisation.';
$string['leftnav'] = 'Table des matières';
$string['leftnavdesc'] = 'Choisissez où afficher la table des matières. La liste permet d\'afficher plus de contenu et est pratique pour les cours comportant de nombreuses rubriques.';
$string['loading'] = 'Chargement en cours...';
$string['loggedinasguest'] = 'Vous êtes connecté en tant qu\'utilisateur anonyme';
$string['loggedoutmsg'] = 'Vous êtes actuellement déconnecté. Si vous souhaitez continuer à utiliser ce site, reconnectez-vous.';
$string['loggedoutmsgtitle'] = 'Vous êtes déconnecté.';
$string['loggedoutfailmsg'] = 'Vous devez être connecté à {$a}.';
$string['loginform'] = 'Connexion';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Votre logo est affiché dans l\'en-tête sur tout le site.';
$string['menu'] = 'Mes cours';
$string['messageread'] = 'Message lu';
$string['messages'] = 'Messages';
$string['messagestoggle'] = 'Messages';
$string['messagestoggledesc'] = 'Montrez aux utilisateurs les messages les plus récents qu\'ils ont reçus au cours des 12 dernières semaines.';
$string['more'] = 'Plus';
$string['morenews'] = 'Plus de nouvelles';
$string['movingstartedhelp'] = 'Accéder à l\'emplacement où vous souhaitez insérer la section "{$a}"';
$string['movingdropsectionhelp'] = 'Insérer la section "{$a->moving}" avant la section "{$a->before}"';
$string['moving'] = 'Déplacement de "{$a}"';
$string['movingcount'] = 'Déplacement de {$a} objets';
$string['movefailed'] = 'Échec du déplacement pour "{$a}"';
$string['move'] = 'Déplacer « {$a} »';
$string['movehere'] = 'Déplacer ici';
$string['movesection'] = 'Déplacer la section';
$string['navbarbg'] = 'Couleur du fond';
$string['navbarlink'] = 'Couleur du texte';
$string['navbarbuttoncolor'] = 'Couleur du fond';
$string['navbarbuttonlink'] = 'Couleur du texte';
$string['nextsection'] = 'Section suivante';
$string['nodeadlines'] = 'Vous n\'avez pas d\'échéances à venir.';
$string['noforumposts'] = 'Aucun message de forum à afficher.';
$string['nograded'] = 'Vous n\'avez aucun feed-back récent.';
$string['nograding'] = 'Vous n\'avez aucun travail remis à noter.';
$string['nomessages'] = 'Vous n\'avez pas de messages.';
$string['notanswered'] = 'Non répondue';
$string['notattempted'] = 'Aucune tentative';
$string['notcontributed'] = 'Contribution non apportée';
$string['notpublished'] = 'Non publié pour les étudiants';
$string['notsubmitted'] = 'Non remis';
$string['overdue'] = 'En retard';
$string['personalmenu'] = 'Menu personnel';
$string['personalmenufeatures'] = 'Fonctionnalités du menu personnel';
$string['personalmenulogintoggle'] = 'Afficher le menu personnel lors de la connexion';
$string['personalmenulogintoggledesc'] = 'Ouvre immédiatement le menu personnel après la connexion';
$string['personalmenuadvancedfeedsenable'] = 'Activer les flux avancés';
$string['personalmenuadvancedfeedsenabledesc'] = 'Les flux avancés chargent des éléments de menu personnalisés, ce qui permet de réduire les temps de chargement et d\'actualiser le contenu sur demande.';
$string['personalmenuadvancedfeedsperpage'] = 'Nombre d\'éléments d\'affichage des flux avancés';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Choisissez le nombre d\'éléments à afficher dans le flux. Les utilisateurs pourront sélectionner l\'option <strong>Voir plus</strong> pour afficher davantage d\'éléments.';
$string['personalmenuadvancedfeedslifetime'] = 'Durée de vie des flux avancés';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Choisissez la durée pendant laquelle les flux seront mis en cache dans le navigateur après connexion. Sélectionner une valeur de 0 empêchera la mise en cache des flux dans le navigateur.';
$string['personalmenurefreshdeadlines'] = 'Actualiser les échéances à l\'aide d\'une tâche planifiée.';
$string['personalmenurefreshdeadlinesdesc'] = 'Lorsque la tâche s\'exécute, les données d\'échéance seront actualisées pour permettre un chargement plus rapide des pages.';
$string['pld'] = 'CPP';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Image de couverture';
$string['posterdesc'] = 'Image d\'en-tête de grande taille destinée à la page d\'accueil de votre site. Les images en mode paysage (1200 pixels x 600 pixels ou plus) sont plus optimales.';
$string['poweredbyrunby'] = 'Conçu avec <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
une technologie <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>
Copyright &#169; {$a->year} Open LMS, tous droits réservés.';
$string['previoussection'] = 'Section précédente';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'Identifiant du cours que l\'utilisateur a ajouté à ses favoris';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'Identifiant de l\'utilisateur qui a ajouté le cours à ses favoris';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'Horodatage de l\'ajout du cours aux favoris de l\'utilisateur';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Enregistre les cours favoris de l\'utilisateur pour Snap';
$string['problemsfound'] = 'Problèmes détectés';
$string['progress'] = 'Progression';
$string['readmore'] = 'En savoir plus&nbsp;"';
$string['recentactivity'] = 'Activité récente';
$string['recentfeedback'] = 'Feed-backs';
$string['region-main'] = 'Menu principal';
$string['region-side-main-box'] = 'Menu principal';
$string['region-side-post'] = 'Droit';
$string['region-side-pre'] = 'Gauche (flottant)';
$string['region-side-top'] = 'En haut';
$string['released'] = 'Version : {$a}';
$string['reopened'] = 'Réouvert';
$string['resourcedisplay'] = 'Affichage des ressources';
$string['resourcedisplayhelp'] = 'Sélectionnez le mode d\'affichage des pièces jointes et des liens dans votre cours. Le thème Snap ne prend pas en charge les fichiers multimédias dans la brève description des fiches de ressources et d\'activité.';
$string['displaydescription'] = 'Afficher la description';
$string['displaydescriptionhelp'] = 'Choisissez d\'afficher une description de la ressource et des activités URL dans une nouvelle page d\'abord. Les étudiants accéderont au contenu depuis la description.';
$string['search'] = 'Rechercher du contenu';
$string['seriffont'] = 'Police Serif';
$string['seriffont_desc'] = 'Cette police est utilisée pour la plupart du contenu généré par l\'utilisateur. L\'utilisation d\'une police Serif rend le contenu généré par l\'utilisateur plus lisible, et donne l\'impression qu\'il a été rédigé à la main.';
$string['showcoursegradepersonalmenu'] = 'Notes';
$string['showcoursegradepersonalmenudesc'] = 'Montrer aux utilisateurs leur note dans les cartes de cours dans le menu personnel';
$string['socialmedia'] = 'Réseau social';
$string['submitted'] = 'Devoir soumis';
$string['sitedescription'] = 'Description du site';
$string['subtitle'] = 'Sous-titre';
$string['subtitle_desc'] = 'Décrivez brièvement votre site pour les utilisateurs.';
$string['themecolor'] = 'Couleur des sites';
$string['themecolordesc'] = 'Les couleurs claires fonctionnent mieux et donneront une apparence moderne à votre site.';
$string['title'] = 'Titre';
$string['top'] = 'En haut';
$string['topbarbgcolor'] = 'Couleur de la barre de navigation';
$string['topbarlinkcolor'] = 'Couleur de l\'icône et du lien de la barre de navigation';
$string['topbarbuttoncolor'] = 'Arrière-plan de Mes cours';
$string['togglenavigation'] = 'Activer/désactiver la navigation';
$string['topicactions'] = 'Actions relatives à la rubrique';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'URL de votre compte Twitter.';
$string['unenrolme'] = 'Me désinscrire';
$string['enrolme'] = 'M\'inscrire';
$string['unread'] = 'non lu';
$string['unsupportedcoverimagetype'] = 'Type d\'image de couverture non pris en charge ({$a})';
$string['via'] = 'via';
$string['viewcourse'] = 'Afficher le cours';
$string['viewmore'] = 'Voir plus';
$string['viewyourprofile'] = 'Afficher votre profil';
$string['viewmyfeedback'] = 'Afficher mon feed-back';
$string['viewcalendar'] = 'Afficher mon calendrier';
$string['viewforumposts'] = 'Afficher mes messages du forum';
$string['viewmessaging'] = 'Afficher mes messages';
$string['vieworiginalimage'] = 'Afficher l\'image d\'origine';
$string['visibility'] = 'Visibilité';
$string['xofyanswered'] = '{$a->completed} sur {$a->participants} ont répondu';
$string['xofyattempted'] = '{$a->completed} sur {$a->participants} ont effectué une tentative';
$string['xofycontributed'] = '{$a->completed} sur {$a->participants} ont contribué';
$string['xofysubmitted'] = '{$a->completed} sur {$a->participants} remis';
$string['xungraded'] = '{$a} non noté';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'URL de votre chaîne YouTube.';
$string['showallsectionsdisabled'] = 'En raison de son langage de conception, la fonctionnalité d\'affichage de l\'ensemble des sections sur une seule page n\'est pas disponible sur Snap.';
$string['disabled'] = 'Désactivée';
$string['showappearancedisabled'] = 'Le langage de conception de Snap empêche les modifications des paramètres d\'apparence.';
$string['pbb'] = 'Personnalisation basée sur les profils';
$string['pbb_description'] = 'L\'activation de la <strong>personnalisation basée sur les profils</strong> vous permet de proposer un contenu personnalisé destiné à un groupe d\'utilisateurs donné en fonction du champ de profil utilisateur sélectionné.
<ul><li>La valeur du champ utilisateur est <em>convertie en slug</em> : tous les caractères sont convertis en minuscules et séparés par un tiret (-)</li>
<li>La chaîne <code>snap-pbb-</code> est ajoutée en préfixe</li>
<li>Cette classe sera ajoutée à la balise HTML <code>body</code></li></ul>
Par exemple, <em>Blueberry Extravaganza</em> sera converti en slug de la façon suivante : <code>snap-pbb-blueberry-extravaganza</code><br /><br />
Cette fonctionnalité est utilisée en association avec <a href="https://help.blackboard.com/Blackboard_Open_LMS/Administrator/Manage_a_Site/Course_and_Site_Design/Themes/Snap#advanced-branding_OTP-3" target="_blank">CSS personnalisé</a>,
vous devrez ajouter les sélecteurs CSS en utilisant les nouvelles classes de la section <a class="snap-settings-tab-link" href="#themesnapbranding">Essentiel</a>.';
$string['pbb_enable'] = 'Activer la personnalisation basée sur les profils';
$string['pbb_enable_description'] = 'Ajoute uniquement la classe à la balise BODY si activée.';
$string['pbb_field'] = 'Champ utilisateur à utiliser';
$string['pbb_field_description'] = 'La valeur de ce champ sera convertie en slug et utilisée comme nom de classe CSS précédé de <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Mise en cache de la personnalisation basée sur les profils.';
$string['cachedef_course_card_bg_image'] = 'Mise en cache de l\'image d\'arrière plan du cours.';
$string['cachedef_course_card_teacher_avatar'] = 'Mise en cache des avatars des enseignants.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Mise en cache de l\'index des avatars des enseignants.';
$string['accessforumstringdis'] = 'Option d\'affichage';
$string['accessforumstringmov'] = 'Déplacer les options';
$string['accesscalendarstring'] = 'Calendrier';
$string['accessglobalsearchstring'] = 'Chercher';
$string['admineventwarning'] = 'Pour afficher les événements de tous les cours,';
$string['gotocalendarsnap'] = 'accédez au calendrier du site.';
$string['quizattemptswarn'] = 'Les tentatives des utilisateurs suspendus sont exclues';
$string['quizfeedback'] = 'Feed-backs';
$string['validratio'] = 'Cette combinaison de couleurs ne respecte pas la valeur de proportion minimum WCAG 2.0 de 4.5:1.';
$string['invalidratio'] = 'Cette combinaison de couleurs ne respecte pas la
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">valeur de proportion minimum WCAG 2.0 de 4.5:1</a>. Valeur : « {$a} »';
$string['imageinvalidratio'] = 'Cette image ne respectant pas la valeur de proportion minimum WCAG 2.0 de 4.5:1, elle peut présenter des problèmes de contraste. Valeur moyenne de pixels : « {$a} »';
$string['catinvalidratio'] = 'Les catégories de couleurs suivantes ne respectent pas la
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">valeur de proportion minimum WCAG 2.0 de 4.5:1</a> :
Couleur d\'arrière-plan du site (blanc) : « {$a->white} ». Couleur d\'arrière-plan de la barre de navigation : « {$a->custombar} ». Couleur d\'arrière-plan du bouton Mes cours : « {$a->customnav} »';
$string['imageinvalidratiocategory'] = 'Cette image ne respectant pas la valeur de proportion minimum WCAG 2.0 de 4.5:1, elle peut présenter des problèmes de contraste avec la couleur du thème. Valeur moyenne de pixels : « {$a} »';
$string['lazyload_mod_page'] = 'Activer le chargement différé par défaut pour les ressources des pages';
$string['lazyload_mod_page_description'] = 'Lorsque ce paramètre est activé, il réduit de manière significative le temps de chargement des cours composés de nombreuses pages.';
$string['pmadvancedfeed_viewmore'] = 'Voir plus';
$string['pmadvancedfeed_reload'] = 'Actualiser';
$string['multimediacard'] = 'Les fichiers multimédias ne s\'afficheront pas dans la fiche d\'activité pour le thème Snap. Ceci sera appliqué à la page d\'accueil et aux pages de cours uniquement pour les brèves fiches de ressource et d\'activité.';
$string['enabledlogin'] = 'Options de connexion affichées';
$string['enabledlogindesc'] = 'Sélectionnez les options de connexion à afficher.';
$string['moodlelogin'] = 'Afficher la connexion à Moodle uniquement';
$string['alternativelogin'] = 'Afficher les autres options de connexion uniquement';
$string['bothlogin'] = 'Afficher les deux options de connexion';
$string['enabledloginorder'] = 'Ordre des options de connexion';
$string['enabledloginorderdesc'] = 'Sélectionnez l\'option de connexion à afficher en premier.';
$string['moodleloginfirst'] = 'Afficher la connexion à Moodle en premier';
$string['alternativeloginfirst'] = 'Afficher les autres options de connexion en premier';
$string['alternativeloginoptions'] = 'Autres options de connexion';
$string['openmessagedrawer'] = 'Ouvrir le tiroir de messagerie.';
$string['design_mod_page'] = 'Activer la conception précédente pour les ressources de pages';
$string['design_mod_page_description'] = 'Lorsque cette option est activée, le contenu de la ressource de page est affiché au sein de la même page, du même cours ou de la même page d\'accueil.';
$string['design_activity_chooser'] = 'Revenir au design original pour le choix de l’activité';
$string['design_activity_chooser_description'] = 'Si cette option est activée, le sélecteur d’activité s’affichera sous son aspect d’origine. Cela affectera le cours et les premières pages.';
$string['refreshdeadlinestask'] = 'Actualiser les échéances des données mises en cache. Cette tâche doit être exécutée avant que tous les utilisateurs se connectent.';
$string['refreshdeadlinestaskoff'] = 'Aucune recherche de données à remplir n’a été effectuée. Veuillez activer le paramètre « Actualiser les dates limites à l\'aide d\'une tâche planifiée » dans les paramètres du menu personnel de Snap pour permettre à cette tâche de renseigner les données mises en cache des dates limites.';
$string['activityrestriction'] = 'Restriction d\'activité';
$string['hideandshowactioncb'] = 'Masquer et afficher l\'action de la case à cocher d\'activité';
