<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings
 *
 * @package   theme_snap
 * @copyright Copyright (c) 2015 Open LMS (https://www.openlms.net)
 * @license   http://opensource.org/licenses/gpl-3.0.html GNU Public License
 */

$string['aboutcourse'] = 'About this Course';
$string['activity'] = 'Activity';
$string['action:changeassetvisibility'] = 'change asset visibility';
$string['action:duplicateasset'] = 'duplicate asset';
$string['action:changesectionvisibility'] = 'change section visibility';
$string['action:highlightsectionvisibility'] = 'highlight section visibility';
$string['action:sectiontoc'] = 'get section table of contents';
$string['addanewsection'] = 'Create a new section';
$string['addresourceoractivity'] = 'Create learning activity';
$string['admin'] = 'Admin';
$string['advancedbrandingheading'] = 'Advanced branding';
$string['advancedbrandingheadingdesc'] = '';
$string['ago'] = 'ago';
$string['answered'] = 'Answered';
$string['appendices'] = 'Tools';
$string['assigndraft'] = 'Draft requires your confirmation';
$string['assignreopened'] = 'Reopened';
$string['at'] = 'at';
$string['attempted'] = 'Attempted';
$string['basics'] = 'Basics';
$string['brandingheading'] = 'Branding';
$string['brandingheadingdesc'] = '';
$string['browse'] = 'Browse';
$string['browseallcourses'] = 'Browse all courses';
$string['cachedef_activity_deadlines'] = 'Cache store for a users activity deadlines.';
$string['cachedef_generalstaticappcache'] = 'Snap general static application level cache';
$string['cachedef_course_completion_progress'] = 'This is used to cache completion data per course / user.';
$string['cachedef_course_completion_progress_ts'] = 'This is used so that we can invalidate session level caches if the course completion settings for a course or module change.';
$string['cachedef_webservicedefinitions'] = 'Caching for auto generated web service definitions.';
$string['card'] = 'Card';
$string['categoryedit'] = 'Edit category';
$string['category_color'] = 'Category color';
$string['category_color_description'] = 'Course Category color. Child courses take the nearest parent category configuration';
$string['category_color_palette'] = 'Color palette';
$string['category_color_palette_description'] = 'See the corresponding hexadecimal value for the given color. This wont
affect any configuration, it is just a sample to help users build the configuration value.';
$string['changecoverimage'] = 'Change cover image';
$string['changefullname'] = 'Change site name';
$string['chapters'] = 'Chapters';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Close';
$string['conditional'] = 'Conditional';
$string['contents'] = 'Contents';
$string['contributed'] = 'Contributed';
$string['courses'] = 'Courses';
$string['coursecontacts'] = 'Course Contacts';
$string['coursedisplay'] = 'Course display';
$string['coursefootertoggle'] = 'Course footer';
$string['coursefootertoggledesc'] = 'The Course footer shows useful information to users on a course page including course contacts, course description and recent activity in the course.';
$string['courseformatnotification'] = 'The current course format you are using is not fully supported by the Snap theme. For the best experience Open LMS recommends using the Topics or Weekly course formats with the Snap theme. The course format can be changed in the <a href="{$a}">course settings</a>.';
$string['coursefixydefaulttext'] = 'You are currently not enrolled in any courses.<br>Courses you are enrolled in will be shown here.';
$string['coursegrade'] = 'Course grade:';
$string['coursepartialrender'] = 'Enable lazy loading for course sections';
$string['coursepartialrenderdesc'] = 'If enabled, course sections load on demand when selected by a user. This helps courses with large amounts of content load faster.';
$string['coursenavigation'] = 'Course navigation';
$string['coursesummaryfilesunsuitable'] = 'Please empty your course summary files before you attempt to change the cover image';
$string['coursetools'] = 'Course Dashboard';
$string['coverdisplay'] = 'Cover display';
$string['covercarousel'] = 'Cover carousel';
$string['covercarouselon'] = 'Use Cover carousel';
$string['covercarouseldescription'] = '<p>The carousel is a set of rotating banners, or a slideshow, that displays on the homepage of your site instead of the cover image.</p>
<p>Add up to 3 images, a title for each slide, and an optional subtitle. Images of 1200 x 600 pixels work best.</p>';
$string['coverimage'] = 'Cover image';
$string['covervideo'] = 'Cover video';
$string['comingsoon'] = 'Coming soon!';
$string['createsection'] = 'Create section';
$string['current'] = 'Current';
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Please be aware that with great power comes great responsibility.  Any issue caused by the CSS added here is your responsibility to resolve. Open LMS Support does not troubleshoot nor provide any help with CSS-related content.';
$string['customtopbar'] = 'Navigation bar';
$string['customisenavbar'] = 'Change navigation bar colors';
$string['customisenavbutton'] = 'Change My Courses button colors';
$string['customisecustommenu'] = 'Change custom menu text color';
$string['custommenutext'] = 'Custom menu text color';
$string['deadlines'] = 'Deadlines';
$string['deadlinestoggle'] = 'Deadlines';
$string['deadlinestoggledesc'] = 'Show users any upcoming activity deadlines from enrolled courses.';
$string['defaultsummary'] = 'Use this area to describe what this topic is about - with text, images, audio & video.';
$string['defaultintrosummary'] = 'Welcome to your new course {$a}.
<br>Start by describing what your course is about using text, images, audio & video.';
$string['defaulttopictitle'] = 'Untitled Topic';
$string['debugerrors'] = 'Debug Errors';
$string['deleteassetconfirm'] = 'Delete {$a}';
$string['deletingasset'] = 'Deleting {$a}';
$string['deletingassetname'] = 'Deleting {$a->type} "{$a->name}"';
$string['deletesectionconfirm'] = 'Delete Section';
$string['deletingsection'] = 'Deleting section "{$a}"';
$string['draft'] = 'Not published to students';
$string['dropzonelabel'] = 'Drop files to attach, or <span class="fake-link">browse</span>';
$string['due'] = 'Due {$a}';
$string['edit'] = 'Edit "{$a}"';
$string['editcoursecontent'] = 'Edit blocks';
$string['editcoursesettings'] = 'Course settings';
$string['editcoursetopic'] = 'Edit section';
$string['editcustomfooter'] = 'Edit footer';
$string['editcustommenu'] = 'Edit custom menu';
$string['error'] = 'Error';
$string['errorgettingfeed'] = 'Error occurred while getting feed items.';
$string['error:categorycolorinvalidjson'] = 'Incorrect JSON format for course categories';
$string['error:categorycolorinvalidvalue'] = 'Record id or color value for category "{$a}" aren\'t valid';
$string['error:categorynotfound'] = 'The category record with id "{$a}" hasn\'t been found';
$string['error:coverimageexceedsmaxbytes'] = 'Cover image exceeds the site level maximum allowed file size ({$a})';
$string['error:coverimageresolutionlow'] = 'For best quality, we recommend a larger image of at least 1024px width.';
$string['error:duplicatedcategoryids'] = 'Incorrect JSON format, some IDs are duplicated';
$string['error:failedtochangeassetvisibility'] = 'Failed to hide/show asset';
$string['error:failedtochangesectionvisibility'] = 'Failed to hide/show section';
$string['error:failedtohighlightsection'] = 'Failed to highlight section';
$string['error:failedtoduplicateasset'] = 'Failed to duplicate';
$string['error:failedtodeleteasset'] = 'Failed to delete asset';
$string['error:failedtotoc'] = 'Failed to get TOC.';
$string['extension'] = 'Extension {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'The url of your facebook page.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Favicons appear in your web browser’s address bar, in a user’s bookmarks and mobile shortcuts.';
$string['favorite'] = 'Favorite {$a}';
$string['favorited'] = 'Favorited {$a}';
$string['featurespots'] = 'Feature spots';
$string['featurespotsedit'] = 'Edit feature spots';
$string['featurespotshelp'] = '<p>Add up to 3 feature spots to your site&#8217;s front page to highlight the main benefits to current and potential users.</p>
<p>Add a title, content, and an optional image for each feature. Images should to be square, and no larger than 200px by 200px.</p>';
$string['featurespotsheading'] = 'Feature spots heading';
$string['featureonetitle'] = 'Feature 1 title';
$string['featuretwotitle'] = 'Feature 2 title';
$string['featurethreetitle'] = 'Feature 3 title';
$string['featureonetitlelink'] = 'Feature 1 title link';
$string['featuretwotitlelink'] = 'Feature 2 title link';
$string['featurethreetitlelink'] = 'Feature 3 title link';
$string['featuretitlelinkdesc'] = 'Type the URL you want to link this feature spot to. You can add external or internal links inside your site. For adding an internal link, please copy it from the site URL including /. For example, to have a link to a course, it would be "/course/view.php?id=160". To add an external link start the link with https://';
$string['featureonetitlecb'] = 'Feature 1 open in a new window';
$string['featuretwotitlecb'] = 'Feature 2 open in a new window';
$string['featurethreetitlecb'] = 'Feature 3 open in a new window';
$string['featuretitlecbdesc'] = 'If enabled, the link added to the featured spot will be opened in a new window';
$string['featureonetext'] = 'Feature 1 content';
$string['featuretwotext'] = 'Feature 2 content';
$string['featurethreetext'] = 'Feature 3 content';
$string['featureoneimage'] = 'Feature 1 image';
$string['featuretwoimage'] = 'Feature 2 image';
$string['featurethreeimage'] = 'Feature 3 image';
$string['featuredcourses'] = 'Featured courses';
$string['featuredcourseshelp'] = 'Highlight up to 8 featured courses to your site&#8217;s front page. Type the Course ID to feature a course.';
$string['featuredcoursesheading'] = 'Featured courses heading';
$string['featuredcourseone'] = 'Featured course 1';
$string['featuredcoursetwo'] = 'Featured course 2';
$string['featuredcoursethree'] = 'Featured course 3';
$string['featuredcoursefour'] = 'Featured course 4';
$string['featuredcoursefive'] = 'Featured course 5';
$string['featuredcoursesix'] = 'Featured course 6';
$string['featuredcourseseven'] = 'Featured course 7';
$string['featuredcourseeight'] = 'Featured course 8';
$string['featuredcoursesedit'] = 'Edit featured courses';
$string['featuredcoursesbrowseall'] = 'Browse all courses';
$string['featuredcoursesbrowsealldesc'] = 'Add a browse all courses link';
$string['feedbackavailable'] = 'Feedback available';
$string['feedbacktoggle'] = 'Feedback and grading';
$string['feedbacktoggledesc'] = 'Show learners their most recent feedback, and educators the most recent submissions that need grading.';
$string['footnote'] = 'Site footer';
$string['footnotedesc'] = 'Your footer is displayed across the entire site. This is the best place to put links to help, support and any other sites your organization has that you want to share with learners and educators. For example, the library or an email address.';
$string['forcepwdwarningpersonalmenu'] = 'You must <a href="{$a}">change your password</a> before using the personal menu.';
$string['forumauthor'] = 'Author';
$string['forumlastpost'] = 'Last Post';
$string['forumpicturegroup'] = 'Group';
$string['forumreplies'] = 'Replies';
$string['forumtopic'] = 'Topic';
$string['forumposts'] = 'Forum posts';
$string['forumpoststoggle'] = 'Forum posts';
$string['forumpoststoggledesc'] = 'Show users the 10 most recent forum posts from their courses';
$string['fullname'] = 'Site name';
$string['fullnamedesc'] = 'The name of your site.';
$string['graderadviseuserreport'] = 'The "grader report" does not work well on mobile devices. The "user report" is recommended instead';
$string['grading'] = 'Grading';
$string['help'] = 'Help';
$string['helpguide'] = 'Help guide';
$string['headingfont'] = 'Heading font';
$string['headingfont_desc'] = 'This font is used in the headings (h1 - h6 elements) across your site. If you are including a custom webfont remember to add it to the moodle extra html form.';
$string['helpwithlogin'] = 'Help with login';
$string['helpwithloginandguest'] = 'Help with login / guest access';
$string['hiddencoursestoggle'] = 'Hidden courses';
$string['highlightedsection'] = 'highlighted';
$string['home'] = 'home';
$string['image'] = 'image';
$string['images'] = 'Images';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'The url of your instagram account.';
$string['introduction'] = 'Introduction';
$string['jsontext'] = 'JSON Text';
$string['jsontextdescription'] = 'The text area validates the given JSON, so only existing categories are allowed,
only numerical values as id records (category records) are valid and only hexadecimal values are accepted as colors.
Here is an example:<br>
{"1":"#FAAFFF",<br>
"45":"#AFF",<br>
"65":"#FFF228",<br>
"12":"#CC0084",<br>
"56":"#CC0087",<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Open LMS Knowledge Base';
$string['list'] = 'List';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'The url of your organisation&#8217;s LinkedIn.';
$string['leftnav'] = 'Table of contents';
$string['leftnavdesc'] = 'Select where to display the table of contents. List gives more room for content and works well for courses with many topics.';
$string['loading'] = 'Loading...';
$string['loggedinasguest'] = 'You are logged in as guest';
$string['loggedoutmsg'] = 'You are currently logged out. If you wish to continue using this site, please log back in.';
$string['loggedoutmsgtitle'] = 'You are logged out';
$string['loggedoutfailmsg'] = 'You must be logged in to {$a}.';
$string['loginform'] = 'Login';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Your logo is displayed in the header across the entire site..';
$string['menu'] = 'My Courses';
$string['messageread'] = 'Message Read';
$string['messages'] = 'Messages';
$string['messagestoggle'] = 'Messages';
$string['messagestoggledesc'] = 'Show users their most recent messages received over the last 12 weeks.';
$string['more'] = 'More';
$string['morenews'] = 'More news';
$string['movingstartedhelp'] = 'Navigate to where you would like to place section "{$a}"';
$string['movingdropsectionhelp'] = 'Place section "{$a->moving}" before section "{$a->before}"';
$string['moving'] = 'Moving "{$a}"';
$string['movingcount'] = 'Moving {$a} objects';
$string['movefailed'] = 'Move failed for "{$a}"';
$string['move'] = 'Move "{$a}"';
$string['movehere'] = 'Move here';
$string['movesection'] = 'Move section';
$string['navbarbg'] = 'Background color';
$string['navbarlink'] = 'Text color';
$string['navbarbuttoncolor'] = 'Background color';
$string['navbarbuttonlink'] = 'Text color';
$string['nextsection'] = 'Next section';
$string['nodeadlines'] = 'You have no upcoming deadlines.';
$string['noforumposts'] = 'You have no relevant forum posts.';
$string['nograded'] = 'You have no recent feedback.';
$string['nograding'] = 'You have no submissions to grade.';
$string['nomessages'] = 'You have no messages.';
$string['notanswered'] = 'Not answered';
$string['notattempted'] = 'Not attempted';
$string['notcontributed'] = 'Not contributed';
$string['notpublished'] = 'Not published to students';
$string['notsubmitted'] = 'Not Submitted';
$string['overdue'] = 'Overdue';
$string['personalmenu'] = 'Personal menu';
$string['personalmenufeatures'] = 'Personal menu features';
$string['personalmenulogintoggle'] = 'Show personal menu on login';
$string['personalmenulogintoggledesc'] = 'Opens the personal menu immediately after login';
$string['personalmenuadvancedfeedsenable'] = 'Enable Advanced feeds';
$string['personalmenuadvancedfeedsenabledesc'] = 'Advanced feeds loads some personal menu items which allows faster load times and refreshes content on demand.';
$string['personalmenuadvancedfeedsperpage'] = 'Advanced feeds item display count';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Choose the number of items to display in the feed. Users can select <strong>View more</strong> to display additional items.';
$string['personalmenuadvancedfeedslifetime'] = 'Advanced feeds life time';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Choose the amount of time the feeds will be cached in the browser after login. Setting the value to 0 won\'t cache the feeds in the browser.';
$string['personalmenurefreshdeadlines'] = 'Refresh deadlines using scheduled task.';
$string['personalmenurefreshdeadlinesdesc'] = 'When the task runs, deadline data will be refreshed for faster page load times.';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Cover image';
$string['posterdesc'] = 'A large header image for the front page of your site. Landscape images (1200 x 600 pixels) or larger work best.';
$string['poweredbyrunby'] = 'Built with <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
    a <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>-based product.<br>
    Copyright &#169; {$a->year} Open LMS, All Rights Reserved.';
$string['previoussection'] = 'Previous section';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'The course ID of the course that the user favorited';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'The user ID of the user that favorited the course';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'The timestamp of when the user favorited the course';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Stores users\' course favorites for Snap';
$string['problemsfound'] = 'Problems Found';
$string['progress'] = 'Progress';
$string['readmore'] = 'Read more&nbsp;»';
$string['recentactivity'] = 'Recent Activity';
$string['recentfeedback'] = 'Feedback';
$string['region-main'] = 'Main';
$string['region-side-main-box'] = 'Main';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['region-side-top'] = 'Top';
$string['released'] = 'Released: {$a}';
$string['reopened'] = 'Reopened';
$string['resourcedisplay'] = 'Resource display';
$string['resourcedisplayhelp'] = 'Select how attachments and links appear in your course. The Snap theme doesn\'t support multimedia files in the small activity and resource cards\' description.';
$string['displaydescription'] = 'Display description';
$string['displaydescriptionhelp'] = 'Select to show a description of resource and URL activities in a new page first. Students will access content from the description.';
$string['search'] = 'Search contents';
$string['seriffont'] = 'Serif font';
$string['seriffont_desc'] = 'This font is used for most user generated content. Using a serif font makes user generated content more readable, and feel like it is written by a human.';
$string['showcoursegradepersonalmenu'] = 'Grades';
$string['showcoursegradepersonalmenudesc'] = 'Show users their grade in course cards in the personal menu';
$string['socialmedia'] = 'Social media';
$string['submitted'] = 'Submitted';
$string['sitedescription'] = 'Site description';
$string['subtitle'] = 'Subtitle';
$string['subtitle_desc'] = 'Briefly describe your site for users.';
$string['themecolor'] = 'Site color';
$string['themecolordesc'] = 'Bright colors work best and will give your site a modern feel.';
$string['title'] = 'Title';
$string['top'] = 'Top';
$string['topbarbgcolor'] = 'Navigation bar color';
$string['topbarlinkcolor'] = 'Navigation bar link and icon color';
$string['topbarbuttoncolor'] = 'My Courses background';
$string['togglenavigation'] = 'Toggle navigation';
$string['topicactions'] = 'Topic actions';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'The url of your twitter account.';
$string['unenrolme'] = 'Unenrol me';
$string['enrolme'] = 'Enrol me';
$string['unread'] = 'unread';
$string['unsupportedcoverimagetype'] = 'Unsupported cover image type ({$a})';
$string['via'] = 'via';
$string['viewcourse'] = 'View Course';
$string['viewmore'] = 'View more';
$string['viewyourprofile'] = 'View your profile';
$string['viewmyfeedback'] = 'View my feedback';
$string['viewcalendar'] = 'View my calendar';
$string['viewforumposts'] = 'View my forum posts';
$string['viewmessaging'] = 'View my messages';
$string['vieworiginalimage'] = 'View original image';
$string['visibility'] = 'Visibility';
$string['xofyanswered'] = '{$a->completed} of {$a->participants} Answered';
$string['xofyattempted'] = '{$a->completed} of {$a->participants} Attempted';
$string['xofycontributed'] = '{$a->completed} of {$a->participants} Contributed';
$string['xofysubmitted'] = '{$a->completed} of {$a->participants} Submitted';
$string['xungraded'] = '{$a} Ungraded';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'The url of your youtube channel.';
$string['showallsectionsdisabled'] = 'Due to its design language, "Show all sections on one page" isn\'t available in Snap.';
$string['disabled'] = 'Disabled';
$string['showappearancedisabled'] = 'Snap\'s design language prevents changes to "Appearance" settings.';
$string['pbb'] = 'Profile based branding';
$string['pbb_description'] = 'By enabling <strong>Profile based branding</strong>, you will be able to customize the branding experience for a specific group of users based on the chosen user profile field.
<ul><li>The user field value will be <em>slugified</em>; converting all characters to lower case and separating them with a dash (-)</li>
<li>The string <code>snap-pbb-</code> will be prepended</li>
<li>This class will be added to the <code>body</code> Html tag</li></ul>
For Example, the user field value <em>Blueberry Extravaganza</em> will be slugified to be <code>snap-pbb-blueberry-extravaganza</code><br /><br />
This feature is used in conjunction with <a href="https://help.blackboard.com/Blackboard_Open_LMS/Administrator/Manage_a_Site/Course_and_Site_Design/Themes/Snap#advanced-branding_OTP-3" target="_blank">Custom CSS</a>,
you\'ll need to add CSS selectors using the new classes in the <a class="snap-settings-tab-link" href="#themesnapbranding">Basics</a> section.';
$string['pbb_enable'] = 'Enable Profile based branding';
$string['pbb_enable_description'] = 'Only adds the class to the body tag if active.';
$string['pbb_field'] = 'User field to use';
$string['pbb_field_description'] = 'This field\'s value will be slugified and used as a CSS class name prepended by <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Caching for Profile based branding.';
$string['cachedef_course_card_bg_image'] = 'Caching for course background image.';
$string['cachedef_course_card_teacher_avatar'] = 'Caching for teacher avatars.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Caching for teacher avatars index.';
$string['accessforumstringdis'] = 'Display options';
$string['accessforumstringmov'] = 'Move options';
$string['accesscalendarstring'] = 'Calendar';
$string['accessglobalsearchstring'] = 'Search';
$string['admineventwarning'] = 'To see events from all courses, ';
$string['gotocalendarsnap'] = 'go to site calendar.';
$string['quizattemptswarn'] = 'Excludes attempts from suspended users';
$string['quizfeedback'] = 'Feedback';
$string['validratio'] = 'This combination of colors does comply with the WCAG 2.0 minimum ratio value 4.5:1';
$string['invalidratio'] = 'This color combination doesn\'t comply with the
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a>. Value: "{$a}"';
$string['imageinvalidratio'] = 'This image could have contrast problems due not compliance with the WCAG 2.0 minimum ratio value 4.5:1. Average pixel value: "{$a}"';
$string['catinvalidratio'] = 'The following color categories don\'t comply with the
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a> :
Against site background color (white): "{$a->white}". Against navigation bar background color: "{$a->custombar}". Against My Courses button background color: "{$a->customnav}"';
$string['imageinvalidratiocategory'] = 'This image could have contrast problems with the theme color due not compliance with the WCAG 2.0 minimum ratio value 4.5:1. Average pixel value: "{$a}"';
$string['browseallcourses'] = 'Browse all courses';
$string['lazyload_mod_page'] = 'Enable default lazy loading for page resources';
$string['lazyload_mod_page_description'] = 'If enabled, this setting significantly decreases course page load times for courses with many pages.';
$string['pmadvancedfeed_viewmore'] = 'View more';
$string['pmadvancedfeed_reload'] = 'Refresh';
$string['multimediacard'] = 'Multimedia files won\'t be displayed in the activity card views for the Snap theme. This will be applied in homepage and course pages only for the small activity and resource cards.';
$string['enabledlogin'] = 'Displayed login options';
$string['enabledlogindesc'] = 'Select the login options that should be displayed.';
$string['moodlelogin'] = 'Display Moodle login only';
$string['alternativelogin'] = 'Display alternative login options only';
$string['bothlogin'] = 'Display both login options';
$string['enabledloginorder'] = 'Login options order';
$string['enabledloginorderdesc'] = 'Select which login option should be displayed first.';
$string['moodleloginfirst'] = 'Display Moodle login first';
$string['alternativeloginfirst'] = 'Display alternative login options first';
$string['alternativeloginoptions'] = 'Alternative login options';
$string['openmessagedrawer'] = 'Open messaging drawer. ';
$string['design_mod_page'] = 'Enable previous design for page resources';
$string['design_mod_page_description'] = 'If enabled, page resource content will be displayed inside the same page, course or front page.';
$string['design_activity_chooser'] = 'Roll back to the original design for the activity chooser';
$string['design_activity_chooser_description'] = 'If enabled, the activity chooser will be displayed with the original design. This will affect the course and front pages.';
$string['refreshdeadlinestask'] = 'Refresh deadlines cached data. This should be run before all users login.';
$string['resetdeadlinesquerycounttask'] = 'Reset deadlines query count';
$string['refreshdeadlinestaskoff'] = 'Didn\'t look for data to populate. Please turn on the setting "Refresh deadlines using scheduled task" in Snap\'s Personal menu settings to allow this task to populate deadlines cached data.';
$string['activityrestriction'] = 'Activity restriction';
$string['hideandshowactioncb'] = 'Hide and show activity checkbox action';
$string['retryfeed'] = 'This feed is currently unavailable, please check back later. Feed: {$a}';
$string['loadingfeed'] = 'Loading...may take time';
$string['hvpcustomcss'] = 'H5P Custom CSS';
$string['hvpcustomcssdesc'] = 'Custom CSS for the H5P module (moodle.org/plugins/mod_hvp) if installed.';
$string['courselimitstrdanger'] = 'Course limit reached progress bar will not be displayed.';
$string['courselimitstrwarning'] = 'If more than {$a} courses are listed progress bar will not be displayed';
