<?php
namespace core_user\output\myprofile;
defined('MOODLE_INTERNAL') || die;
/**
 * Report log renderer's for printing reports.
 *
 * @since      Moodle 2.9
 * @package    core_user
 * @copyright  2015 onwards Ankit Agarwal <ankit.agrr@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class renderer extends \plugin_renderer_base {
    /**
     * Render the whole tree.
     *
     * @param tree $tree
     *
     * @return string
     */
    public function render_tree(tree $tree) {
        /*
        @@@ Global Variables Items //Start
        */
            global $PAGE, $OUTPUT, $SESSION, $SITE, $DB, $USER, $CFG;
        /*
        @@@ Global Variables Items //End
        */

        /*
        @@@ local Variables Items - Page main Id //Start
        */
            $ig_user__id = optional_param('id', 0, PARAM_INT);
            $ig_user__id = $ig_user__id ? $ig_user__id : $USER->id;  
        /*
        @@@ local Variables Items - Page main Id //End
        */

        $ig_page = new \stdClass();
        $ig_page->id = $ig_user__id;


        $return = \html_writer::start_tag('div', array('class' => 'profile_tree'));
        $categories = $tree->categories;
        foreach ($categories as $category) {
            $return .= $this->render($category);
        }
        $return .= \html_writer::end_tag('div');
        return $return;
    }

    /**
     * Render a category.
     *
     * @param category $category
     *
     * @return string
     */
    public function render_category(category $category) {
        $classes = $category->classes;

          $return = '<div class="node_category '.$classes.'">
                  <div id="accordion" class="user_profile__wrapper">
                    <div class="user_profile__inner">';

            $return .= '<h3 class="profile_heading">
                          <a href="#profile_'.$category->name.'" class="accordion-toggle link" data-toggle="collapse" data-parent="#accordion">'.$category->title.'</a>
                        </h3>';
      $nodes = $category->nodes;
      if (empty($nodes)) {
          // No nodes, nothing to render.
          return '';
      }
      $return .= '<div id="profile_'.$category->name.'" class="profile_collapse collapse">
                    <div class="profile_container__box">
                      <div class="profile_content__area">';
      foreach ($nodes as $node) {
          if(!($node->content)) {
            $return .= '<div class="content style-link"><div class="circle"></div><h4 class="edu_stats edu_stats_link">'.$this->render($node).'</h4></div>';
          } else {
            $return .= $this->render($node);
          }
      }
      $return .='</div></div></div>';
      $return .= '</div></div></div>';
      return $return;
    }

    /**
     * Render a node.
     *
     * @param node $node
     *
     * @return string
     */
    public function render_node(node $node) {
    $return = '';
      if (is_object($node->url)) {
          $header = \html_writer::link($node->url, $node->title);
      } else {
          $header = $node->title;
      }
      $icon = $node->icon;
      if (!empty($icon)) {
          $header .= $this->render($icon);
      }
      $content = $node->content;
      $classes = $node->classes;
      if (!empty($content)) {
          if ($header) {
              // There is some content to display below this make this a header.
              $return = '<h4 class="profile_sub__heading">'.$header.'</h4>';
              $return .= '<span class="profile_sub__content">'.$content.'</span>';
          } else {
              $return = \html_writer::span($content);
          }
          if ($classes) {
              $return = '<div class="profile_box"><div class="circle"></div>'.$return.'</div>';
          } else {
              $return = '<div class="profile_box"><div class="circle"></div>'.$return.'</div>';
          }
      } else {
                $return = $header;
      }

      return $return;
    }
}
