<?php

/*namespace theme_ignite\output\core;*/
defined('MOODLE_INTERNAL') || die();

require_once ($CFG->dirroot . "/course/renderer.php");

class igCustomCourseHandler{

    public function igCustomCourseController($categoryId){

        global $CFG, $DB;

        if ($DB->record_exists('course_categories', array('id' => $categoryId))) {

            $chelper = new coursecat_helper();
            $categoryObj = core_course_category::get($categoryId);

            $igCategory = new \stdClass();

            $cateCourses = $categoryObj->get_courses();
            $catCoursesCount = count($cateCourses);

            $cateFetchSubcategories = [];
            $cateSubcategories = [];

            if (!$chelper->get_categories_display_option('nodisplay')) {
                $cateFetchSubcategories = $categoryObj->get_children($chelper->get_categories_display_options());
            }

            foreach($cateFetchSubcategories as $key=>$igsubCategory) {
                $igSubcate = new \stdClass();
                $igSubcate->coursecount = $igsubCategory->coursecount;
                $cateSubcategories[$igsubCategory->id] = $igSubcate;
            }

            $cateSubcategoriesCount = count($cateSubcategories);

            $igCategory->coursesCount = $catCoursesCount;
            $igCategory->subcategoriesCount = $cateSubcategoriesCount;

            return $igCategory;
        }
    }
}

class theme_ignite_core_course_renderer extends core_course_renderer
{
    
    protected function coursecat_tree(coursecat_helper $chelper, $coursecat) {
      // Reset the category expanded flag for this course category tree first.
      $this->categoryexpandedonload = false;
      $categorycontent = $this->coursecat_category_content($chelper, $coursecat, 0);
      if (empty($categorycontent)) {
          return '';
      }

      // Start content generation
      $content = '';

      $content .= $categorycontent;

      return $content;
  }

  protected function coursecat_category_content(coursecat_helper $chelper, $coursecat, $depth) {
        $content = '';
        // Subcategories
        $content .= $this->coursecat_subcategories($chelper, $coursecat, $depth);

        // AUTO show courses: Courses will be shown expanded if this is not nested category,
        // and number of courses no bigger than $CFG->courseswithsummarieslimit.
        $showcoursesauto = $chelper->get_show_courses() == self::COURSECAT_SHOW_COURSES_AUTO;
        if ($showcoursesauto && $depth) {
            // this is definitely collapsed mode
            $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_COLLAPSED);
        }

        // Courses
        if ($chelper->get_show_courses() > core_course_renderer::COURSECAT_SHOW_COURSES_COUNT) {
            $courses = array();
            if (!$chelper->get_courses_display_option('nodisplay')) {
                $courses = $coursecat->get_courses($chelper->get_courses_display_options());
            }
            if ($viewmoreurl = $chelper->get_courses_display_option('viewmoreurl')) {
                // the option for 'View more' link was specified, display more link (if it is link to category view page, add category id)
                if ($viewmoreurl->compare(new moodle_url('/course/index.php'), URL_MATCH_BASE)) {
                    $chelper->set_courses_display_option('viewmoreurl', new moodle_url($viewmoreurl, array('categoryid' => $coursecat->id)));
                }
            }
            $content .= $this->coursecat_courses($chelper, $courses, $coursecat->get_courses_count());
        }

        if ($showcoursesauto) {
            // restore the show_courses back to AUTO
            $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_AUTO);
        }

        return $content;
    }


  public function course_category($category) {
        global $CFG, $PAGE;
        $usertop = core_course_category::user_top();
        if (empty($category)) {
            $coursecat = $usertop;
        } else if (is_object($category) && $category instanceof core_course_category) {
            $coursecat = $category;
        } else {
            $coursecat = core_course_category::get(is_object($category) ? $category->id : $category);
        }

        if ($coursecat->id && $coursecat->is_uservisible()){


            $ig_cc_handler =  new igCustomCourseHandler();
            $ig_cc_controller = $ig_cc_handler->igCustomCourseController($category);
            $ig_c_count = $ig_cc_controller->coursesCount;
            $custom_cate_count = $ig_cc_controller->subcategoriesCount;


            /*
            @@@ Coures/Categories DOM Creation to manipulate //START
            */

            $ig_custom_cc_renderer = '';

            if($ig_c_count > 0){
                $ig_cc_count_res = $ig_c_count === 1 ? $ig_c_count .' '. 'Course' : $ig_c_count .' '. 'Courses';
                $ig_custom_cc_renderer .='<span class="cc_strip__node">'.$ig_cc_count_res. '</span>';
            }

            if($custom_cate_count > 0){
                $ig_cc_category_res = $custom_cate_count === 1 ? $custom_cate_count .' '. 'category' : $custom_cate_count .' '. 'Categories';
                if($ig_custom_cc_renderer === ''){
                    $ig_custom_cc_renderer .= '<span class="cc_strip__node">'.$ig_cc_category_res. '</span>';
                }else{
                    $ig_custom_cc_renderer .= '<span class="cc_strip__node">'.$ig_cc_category_res. '</span>';
                }
            }

        }

        /*
        @@@ Coures/Categories DOM Creation to manipulate //END
        */

        $site = get_site();
        $output = '';

        /*
        @@@ Manage Courses Button/Link/Url //Start
        */
        if ($coursecat->can_create_course() || $coursecat->has_manage_capability()) {
            // Add 'Manage' button if user has permissions to edit this category.
            $managebutton = $this->single_button(new moodle_url('/course/management.php',
                array('categoryid' => $coursecat->id)), get_string('managecourses'), 'get');
            $this->page->set_button($managebutton);
        }

       
        /*
        @@@ Manage Courses Button/Link/Url //End
        */

         $output .='<div class="category_top__wrapper clearfix">';
            if ($coursecat->id && $coursecat->is_uservisible()) {
                $output .= '<div class="categories_count__container">
                    <div class="categories_count__inner">
                        '.$ig_custom_cc_renderer.'
                    </div>
                </div>';
            }

        /*
        @@@ Courses Search & Courses Filter //Start
        */

        if (core_course_category::is_simple_site()) {
            // There is only one category in the system, do not display link to it.
            $strfulllistofcourses = get_string('fulllistofcourses');
            $this->page->set_title("$site->shortname: $strfulllistofcourses");
        } else if (!$coursecat->id || !$coursecat->is_uservisible()) {
            $strcategories = get_string('categories');
            $this->page->set_title("$site->shortname: $strcategories");
        } else {
            $strfulllistofcourses = get_string('fulllistofcourses');
            $this->page->set_title("$site->shortname: $strfulllistofcourses");

            // Print the category selector
            $categorieslist = core_course_category::make_categories_list();
            if (count($categorieslist) > 1) {
                $output .= html_writer::start_tag('div', array('class' => 'categorypicker'));
                $select = new single_select(new moodle_url('/course/index.php'), 'categoryid',
                        core_course_category::make_categories_list(), $coursecat->id, null, 'switchcategory');
                $select->set_label(get_string('categories').':');
                $output .= $this->render($select);
                $output .= html_writer::end_tag('div'); // .categorypicker
            }
        }

        /*
        @@@ Courses Search & Courses Filter //End
        */


        // Print current category description
        $chelper = new coursecat_helper();
        if ($description = $chelper->get_category_formatted_description($coursecat)) {
            /*$output .= $this->box($description, array('class' => 'generalbox info'));*/
        }

        // Prepare parameters for courses and categories lists in the tree
        $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_AUTO)
                ->set_attributes(array('class' => 'category-browse category-browse-'.$coursecat->id));

        $coursedisplayoptions = array();
        $catdisplayoptions = array();
        $browse = optional_param('browse', null, PARAM_ALPHA);
        $perpage = optional_param('perpage', $CFG->coursesperpage, PARAM_INT);
        $page = optional_param('page', 0, PARAM_INT);
        $baseurl = new moodle_url('/course/index.php');
        if ($coursecat->id) {
            $baseurl->param('categoryid', $coursecat->id);
        }
        if ($perpage != $CFG->coursesperpage) {
            $baseurl->param('perpage', $perpage);
        }
        $coursedisplayoptions['limit'] = $perpage;
        $catdisplayoptions['limit'] = $perpage;
        if ($browse === 'courses' || !$coursecat->get_children_count()) {
            $coursedisplayoptions['offset'] = $page * $perpage;
            $coursedisplayoptions['paginationurl'] = new moodle_url($baseurl, array('browse' => 'courses'));
            $catdisplayoptions['nodisplay'] = true;
            $catdisplayoptions['viewmoreurl'] = new moodle_url($baseurl, array('browse' => 'categories'));
            $catdisplayoptions['viewmoretext'] = new lang_string('viewallsubcategories');
        } else if ($browse === 'categories' || !$coursecat->get_courses_count()) {
            $coursedisplayoptions['nodisplay'] = true;
            $catdisplayoptions['offset'] = $page * $perpage;
            $catdisplayoptions['paginationurl'] = new moodle_url($baseurl, array('browse' => 'categories'));
            $coursedisplayoptions['viewmoreurl'] = new moodle_url($baseurl, array('browse' => 'courses'));
            $coursedisplayoptions['viewmoretext'] = new lang_string('viewallcourses');
        } else {
            // we have a category that has both subcategories and courses, display pagination separately
            $coursedisplayoptions['viewmoreurl'] = new moodle_url($baseurl, array('browse' => 'courses', 'page' => 1));
            $catdisplayoptions['viewmoreurl'] = new moodle_url($baseurl, array('browse' => 'categories', 'page' => 1));
        }
        $chelper->set_courses_display_options($coursedisplayoptions)->set_categories_display_options($catdisplayoptions);
        // Add course search form.
        $output .= $this->course_search_form();

        $output .='</div>';
        /*
        @@@ Coures view in category //Start
        */
        // Display course category tree.
        $output .= $this->coursecat_tree($chelper, $coursecat);
        /*
        @@@ Coures view in category //End
        */
        /*
        @@@ Add a new courses Buttons Logic //Start
        */
        // Add action buttons
        $output .= $this->container_start('buttons');
        if ($coursecat->is_uservisible()) {
            $context = get_category_or_system_context($coursecat->id);
            if (has_capability('moodle/course:create', $context)) {
                // Print link to create a new course, for the 1st available category.
                if ($coursecat->id) {
                    $url = new moodle_url('/course/edit.php', array('category' => $coursecat->id, 'returnto' => 'category'));
                } else {
                    $url = new moodle_url('/course/edit.php',
                        array('category' => $CFG->defaultrequestcategory, 'returnto' => 'topcat'));
                }
                $output .= $this->single_button($url, get_string('addnewcourse'), 'get');
            }
            ob_start();
            print_course_request_buttons($context);
            $output .= ob_get_contents();
            ob_end_clean();
        }
        $output .= $this->container_end();
        /*
        @@@ Add a new courses Buttons Logic //End
        */

        return $output;
    }

    protected function coursecat_category(coursecat_helper $chelper, $coursecat, $depth) {

        global $CFG, $PAGE, $DB;

        /*
        @@@ Custom Properties //Start
        */
        $category__name = $coursecat->get_formatted_name();
        $ig_cate_url = new moodle_url('/course/index.php', array('categoryid' => $coursecat->id));

        $ignite_category = $coursecat->id;
        $ignite_categorysummary__withoutformat = $chelper->get_category_formatted_description($coursecat);
        $ignite_categorysummry_row = preg_replace("/<img[^>]+\>/i", " ", $ignite_categorysummary__withoutformat);
        $descendant_courses = $coursecat->get_courses();
        $ignite_elements_count = '';
        $ignite_celement_count = '';
        /*
        @@@ Custom Properties //End
        */


        if ($coursecat->get_children_count() > 0) {
          //$ignite_elements_count .= $coursecat->get_children_count() . ' ' . "Course Categories";
            $ignite_elements_count .= $coursecat->get_children_count() > 1 ? $coursecat->get_children_count() .' '. 'Course categories' : $coursecat->get_children_count() .' '. 'Course category';
            //$ignite_celement_count .= count($coursecat->get_courses()) > 0 ? count($coursecat->get_courses()) .' '. 'Courses' : count($coursecat->get_courses()) .' '. 'Course';
            $ignite_celement_count .= count($coursecat->get_courses());
        } else {
          $ignite_elements_count .= count($coursecat->get_courses()) > 0 ? count($coursecat->get_courses()) .' '. 'Courses' : count($coursecat->get_courses()) .' '. 'Course';
          $ignite_celement_count .= count($coursecat->get_courses());
        }

        $ignite_cate_modified = get_string('modified') . ' ' . userdate($coursecat->timemodified, '%d %B %Y', 0);

        /*
        @@@ Category Images modificatons //START
        */

        $categoryimages = '';
        $imgsrc = '';

        if ($description = $chelper->get_category_formatted_description($coursecat)) {
            $document = new DOMDocument();
            $document->loadHTML($description);
            $xpath = new DOMXPath($document);
            $imgsrc = $xpath->evaluate("string(//img/@src)");
        }

        if($imgsrc){
            $categoryimages .= '<img class="cate_img__tag" src="'.$imgsrc.'" alt="'.$category__name.'">';
        }else{
            foreach($descendant_courses as $child_node_course){
                if($child_node_course === $descendant_courses[key($descendant_courses)]){
                    foreach($child_node_course->get_course_overviewfiles() as $file){
                        $isimage = $file->is_valid_image();
                        $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php", '/'. $file->get_contextid(). '/'. $file->get_component(). '/'. $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
                        if($isimage){
                            $categoryimages .= '<img class="cate_img__tag" src="'.$imgurl.'" alt="'.$category__name.'">';
                        }
                    }
                }
            }
        }

        /*
        @@@ Category Images modificatons //END
        */

        /*
        @@@ Category DOM modifications //START
        */
        $content = '';

        $content .= '
            <div class="col-lg-3 col-md-6 col-sm-12 cat_box">
                <div class="ignite_cc__wrapper">
                    <div class="ignite_cc__inner">';
                    if($categoryimages){
                        $content .= '<div class="category_image__section">
                            '.$categoryimages.'
                            <div class="overlay overlay-bg">
                                <div class="category_image__info">
                                    <h3>'.$category__name.'</h3>
                                    <a class="category_course__link" href="'.$ig_cate_url.'">'.get_string('viewallcourses').'</a>
                                </div>
                            </div>
                        </div>';
                    }
                    $content .= '
                        <div class="ignite_cc__contents">';
                            if(isset($PAGE->theme->settings->course_cate__modified) && ($PAGE->theme->settings->course_cate__modified !== 1)){
                              $content .='<span class="date__container"><i class="cb-calendar-icon"></i>'.$ignite_cate_modified.'</span>';
                            }
                            $content .='
                            <h3><a href="'.$ig_cate_url.'">'.$category__name.'</a></h3>';
                            if($ignite_categorysummry_row){
                                $content .= '<div class="category_summary__wrapper" data-simplebar="init">'.$ignite_categorysummry_row.'</div>';
                            }
                         $content .= '</div>
                        <div class="ignite_cc__count">
                            <div class="ignite_cc_inner__count">
                                <i class="fa fa-folder-open-o" aria-hidden="true"></i>
                                <span>'.$ignite_elements_count.'</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>';
        return $content;
        /*
        @@@ Category DOM modifications //END
        */
        
    }

    protected function coursecat_subcategories(coursecat_helper $chelper, $coursecat, $depth) {
        global $CFG, $PAGE;
        $subcategories = array();
        if (!$chelper->get_categories_display_option('nodisplay')) {
            $subcategories = $coursecat->get_children($chelper->get_categories_display_options());
        }

        $totalcount = $coursecat->get_children_count();
        if (!$totalcount) {
            // Note that we call core_course_category::get_children_count() AFTER core_course_category::get_children()
            // to avoid extra DB requests.
            // Categories count is cached during children categories retrieval.
            return '';
        }

        $content = '';
        $cc_count = '';
        $total_cc_count = count($subcategories) === 1 ? count($subcategories) .' '. 'Course Category' : count($subcategories) .' '. 'Course Categories';

        if ($coursecat->id && $coursecat->is_uservisible()) {
             $cc_count .= '';
        }else{
            if(count($subcategories) > 0){
                if($PAGE->pagelayout !== 'frontpage'){
                    $cc_count .= '<span class="cc_count">'.$total_cc_count.'</span>';
                    $content .='<div class="categories_count__container">'.$cc_count.'</div>';
                }
            } 
        }

        $content .= '<div class="categories__container">';
            $content .= '<div class="categories__wrapper row">';


        // prepare content of paging bar or more link if it is needed
        $paginationurl = $chelper->get_categories_display_option('paginationurl');
        $paginationallowall = $chelper->get_categories_display_option('paginationallowall');
        if ($totalcount > count($subcategories)) {
            if ($paginationurl) {
                // the option 'paginationurl was specified, display pagingbar
                $perpage = $chelper->get_categories_display_option('limit', $CFG->coursesperpage);
                $page = $chelper->get_categories_display_option('offset') / $perpage;
                $pagingbar = $this->paging_bar($totalcount, $page, $perpage,
                        $paginationurl->out(false, array('perpage' => $perpage)));
                if ($paginationallowall) {
                    $pagingbar .= html_writer::tag('div', html_writer::link($paginationurl->out(false, array('perpage' => 'all')),
                            get_string('showall', '', $totalcount)), array('class' => 'paging paging-showall'));
                }
            } else if ($viewmoreurl = $chelper->get_categories_display_option('viewmoreurl')) {
                // the option 'viewmoreurl' was specified, display more link (if it is link to category view page, add category id)
                if ($viewmoreurl->compare(new moodle_url('/course/index.php'), URL_MATCH_BASE)) {
                    $viewmoreurl->param('categoryid', $coursecat->id);
                }
                $viewmoretext = $chelper->get_categories_display_option('viewmoretext', new lang_string('viewmore'));
                $morelink = '<div class="col-lg-12 paging paging-morelink">
                                  <div class="courses_all__btn text-center">
                                    <a class="btn btn-transparent mt-3 mb-3" href="'.$viewmoreurl.'">'.$viewmoretext.'</a>
                                  </div>
                            </div>';
            }
        } else if (($totalcount > $CFG->coursesperpage) && $paginationurl && $paginationallowall) {
            // there are more than one page of results and we are in 'view all' mode, suggest to go back to paginated view mode
            $pagingbar = html_writer::tag('div', html_writer::link($paginationurl->out(false, array('perpage' => $CFG->coursesperpage)),
                get_string('showperpage', '', $CFG->coursesperpage)), array('class' => 'paging paging-showperpage'));
        }

        foreach ($subcategories as $subcategory) {
            $content .= $this->coursecat_category($chelper, $subcategory, $depth + 1);
        }

        if (!empty($pagingbar)) {
            $content .= $pagingbar;
        }
        if (!empty($morelink)) {
            $content .= $morelink;
        }

            $content .= '</div>'; // end tag categories__wrapper
        $content .= '</div>'; // end tag categories__container
        return $content;
    }

    protected function coursecat_coursebox(coursecat_helper $chelper, $course, $additionalclasses = '') {

        global $CFG, $USER;

        if (!isset($this->strings->summary)) {
            $this->strings->summary = get_string('summary');
        }

        if ($chelper->get_show_courses() <= self::COURSECAT_SHOW_COURSES_COUNT) {
            return '';
        }

        if ($course instanceof stdClass) {

            $course = new core_course_list_element($course);
        }


        $content = '';

        $displayInfoNode = ($chelper->get_show_courses() >= self::COURSECAT_SHOW_COURSES_EXPANDED);
        $summaryTopic = $chelper->get_course_formatted_summary($course, array('overflowdiv' => true, 'noclean' => true, 'para' => false));

        $infoCls =(!$course->has_summary()) ? ' non-summary' : '' ;

        $infoCls .= (isset($course->visible) && !$course->visible) ? ' course-hidden' : '';

        $classes = trim('coursebox clearfix '. $additionalclasses . $infoCls);

        // .coursebox
        $content .= html_writer::start_tag('div', array(
            'class' => $classes,
            'data-courseid' => $course->id,
            'data-type' => self::COURSECAT_TYPE_COURSE,
        ));

        $content .= html_writer::start_tag('div', array('class' => 'content'));

        $content .= $this->coursecat_coursebox_content($chelper, $course);

        $content .= html_writer::end_tag('div'); // .content
        $content .= html_writer::end_tag('div'); // .coursebox

        return $content;
    }


    protected function course_enrolment_icons(core_course_list_element $course): string {
        $content = '';
        if ($icons = enrol_get_course_info_icons($course)) {
            $content .= html_writer::start_tag('div', ['class' => 'enrolmenticons']);
            foreach ($icons as $icon) {
                $content .= $this->render($icon);
            }
            $content .= html_writer::end_tag('div');
        }
        return $content;
    }

    

    protected function coursecat_coursebox_content(coursecat_helper $chelper, $course) {

        global $CFG, $OUTPUT, $USER, $PAGE;


        if ($course instanceof stdClass) {

            //From Moodle's version 3.7 (2019052000)
            
            $course = new core_course_list_element($course);
        }



        $content = '';
        $totalFiles = count($course->get_course_overviewfiles());
        $courseDefImg = theme_ignite_moodle_theme_setting($PAGE, 'course_def_img');
        $avFiles = ($totalFiles > 0 || $courseDefImg);
        $content .= html_writer::start_tag('div', array('class' => 'content-wrapper'));

        /*>>> // Course Image Section*/

        // display course overview files
        $contentimages = $contentfiles = '';

        if($avFiles){

            $content .= html_writer::start_tag('div', array('class' => 'course-image'));

                foreach ($course->get_course_overviewfiles() as $file) {

                    $isimage = $file->is_valid_image();

                    $url = file_encode_url("$CFG->wwwroot/pluginfile.php",
                            '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                            $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);


                    if ($isimage) {

                        $contentimages .= $this->custom_coursecat_content_image($chelper, $url,$course);

                    } else {
                        $image = $this->output->pix_icon(file_file_icon($file, 24), $file->get_filename(), 'moodle');
                        $filename = html_writer::tag('span', $image, array('class' => 'fp-icon')).
                                html_writer::tag('span', $file->get_filename(), array('class' => 'fp-filename'));
                        $contentfiles .= html_writer::tag('span',
                                html_writer::link($url, $filename),
                                array('class' => 'coursefile fp-filename-icon'));
                    }
                }

                //Course default image
                $moodle37 = 2019052000;

                if ($contentimages == '' && $courseDefImg) {

                    if ($CFG->version >= $moodle37)
                    {
                        $isImgExist = file_exists($OUTPUT->image_url('course-custom','theme')) ? $OUTPUT->image_url('course-custom','theme') : $OUTPUT->image_url('cc-default','theme');
                    }


                    $contentimages .= $this->custom_coursecat_content_image($chelper, $isImgExist,$course);

                }

                $content .= $contentimages. $contentfiles;

            
                //Course Category Name
                if ($chelper->get_show_courses()) {
                    if ($cat = core_course_category::get($course->category, IGNORE_MISSING)) {
                        $content .= html_writer::start_tag('div', array('class' => 'cc_name', 'data-categoryclass' =>  $cat->get_formatted_name()));
                        $content .= html_writer::start_tag('h4');
                            $content .=
                                    html_writer::link(new moodle_url('/course/index.php', array('categoryid' => $cat->id)),
                                            $cat->get_formatted_name(), array('class' => $cat->visible ? '' : 'dimmed', 'alt' => $cat->get_formatted_name()));
                                $content .= html_writer::end_tag('h4');
                        $content .= html_writer::end_tag('div'); // .coursecat
                    }
                }

                // Display custom fields.
                if ($course->has_custom_fields()) {
                    $handler = core_course\customfield\course_handler::create();
                    $customfields = $handler->display_custom_fields_data($course->get_custom_fields());
                    $content .= \html_writer::tag('div', $customfields, ['class' => 'customfields-container']);
                }


                /*>>> //Teacher's Node*/


        // Display course contacts. See core_course_list_element::get_course_contacts().
        if ($course->has_course_contacts() > 0 || theme_ignite_moodle_theme_setting($PAGE,'course_students_listing')) {

            
            if($course->has_course_contacts() > 0){

                $content .= html_writer::start_tag('ul', array('class' => 'teachers'));


                foreach ($course->get_course_contacts() as $userid => $coursecontact) {

                    global $DB, $OUTPUT;

                    $user = $DB->get_record('user', array('id' => $userid));

                    $face = $OUTPUT->user_picture($user, array('size' => 50));

                    $name = $face/*.$coursecontact['rolename'].': '*/.
                           html_writer::link(new moodle_url('/user/view.php',
                    array('id' => $userid, 'course' => SITEID)),
                    $coursecontact['username']);

                    $content .= html_writer::tag('li', $name);
                }
            }


                if(theme_ignite_moodle_theme_setting($PAGE,'coursestudentscount')){
                    
                }

                $content .= html_writer::end_tag('ul'); // .teachers
            }

            $content .= html_writer::end_tag('div'); // .course-image
        }
        
        /*>>> //Course Wrapper's Node*/

        $content .= html_writer::start_tag('div', array('class' => 'course-wrapper'));

        $courseTag = preg_match('@{mlang@', $chelper->get_course_formatted_name($course)) ?
                format_text($chelper->get_course_formatted_name($course)) : $chelper->get_course_formatted_name($course);

        $courseTagLink = html_writer::link(new moodle_url('/course/view.php', array('id' => $course->id)),
                $courseTag, array('class' => $course->visible ? '' : 'dimmed'));

        /*>>> //Teacher's Node*/


        // Display course contacts. See core_course_list_element::get_course_contacts().
        if ($course->has_course_contacts() > 0 || theme_ignite_moodle_theme_setting($PAGE,'course_students_listing')) {

            
            if($course->has_course_contacts() > 0){

                $content .= html_writer::start_tag('ul', array('class' => 'teachers'));


                foreach ($course->get_course_contacts() as $userid => $coursecontact) {

                    global $DB, $OUTPUT;

                    $user = $DB->get_record('user', array('id' => $userid));

                    $face = $OUTPUT->user_picture($user, array('size' => 50));

                    $name = $face/*.$coursecontact['rolename'].': '*/.
                           html_writer::link(new moodle_url('/user/view.php',
                    array('id' => $userid, 'course' => SITEID)),
                    $coursecontact['username']);

                    $content .= html_writer::tag('li', $name);
                }
            }


            /*if(theme_ignite_moodle_theme_setting($PAGE,'coursestudentscount')){
                
            }*/

            $content .= html_writer::end_tag('ul'); // .teachers
        }

        $content .= html_writer::start_tag('div', array('class' => 'sdate-senroll-wrapper'));

        //Course Start Date
                $content .= '<div class="course-start-date"><h6><i class="cb-calendar-icon"></i>' .
                    userdate($course->startdate, get_string('mmddyyyy', 'theme_ignite')) . '</h6></div>';

        /*>>> //Courses' count Node*/

        $context = context_course::instance($course->id);
        $studentroleid = get_role_users(5, $context);
        $totalstudents = count($studentroleid);

        if($course->has_course_contacts() > 0 || theme_ignite_moodle_theme_setting($PAGE,'course_students_listing')){

            $content .= html_writer::start_tag('div', array('class' => 'enrolled-students'));

                if(theme_ignite_moodle_theme_setting($PAGE,'course_students_listing')){

                    $total_student_content = $totalstudents ? '<em>' .$totalstudents . '</em>' . ($totalstudents == 1 ? ' Student' : ' Students' ) : '<em>0</em> Student';

                    if($totalstudents == 1 || $totalstudents == 0){
                        $content .= '<h6 class="student-icon"><i class="cb-suser-icon"></i>'.$total_student_content.'</h6>';
                    }else{
                        $content .= '<h6 class="student-icons"><i class="cb-muser-icon"></i>'.$total_student_content.'</h6>';
                    }

                }

            $content .= html_writer::end_tag('div');

        }

        $content .= html_writer::end_tag('div'); //sdate-senroll-wrapper //end

        /*>>> //Course's Heading Node*/

        $content .= html_writer::start_tag('div', array('class' => 'courseheading'));
            $content .= html_writer::tag('h3', $courseTagLink, array('class' => 'coursetitle'));

        $content .= html_writer::end_tag('div');

        // display course summary
        if ($course->has_summary()) {
            $content .= html_writer::start_tag('div', array('class' => 'summary babab', 'data-simplebar' => 'init'));

            $content .= $chelper->get_course_formatted_summary($course,
                array('overflowdiv' => true, 'noclean' => true, 'para' => false));
            $content .= html_writer::end_tag('div'); // .summary

        }//End Summary

        
                    
        /*>>> //Visitlink's Node*/

            //$arrow = html_writer::tag('span', '', array('class' => ' arrow-right'));
            $visit = html_writer::tag('span', 'Enter Now');
            $visitlink = html_writer::link(new moodle_url('/course/view.php',
                array('id' => $course->id)), $visit);
            $content .= html_writer::tag('div', $visitlink, array('class' => 'visitlink'));



        $content .= html_writer::end_tag('div'); // .course-wrapper

        $content .= html_writer::end_tag('div'); // .content-wrapper

        return $content;
        
    } //custom_coursecat_content

    protected function custom_coursecat_content_image ($chelper, $url, $course)
        {
            $img = html_writer::empty_tag('img', array('src' => $url, 'alt' => $chelper->get_course_formatted_name($course)));
            $output = html_writer::link(new moodle_url('/course/view.php', array('id' => $course->id)), $img);
            return $output;
        }


} // core_course_renderer_end

