<?php
//namespace theme_ignite\output;

defined('MOODLE_INTERNAL') || die;

require_once('courserenderer.php');
require_once('format_topics_renderer.php');
require_once('user_profile_renderer.php');

class theme_ignite_core_renderer extends \theme_boost\output\core_renderer {

    
    /** @var custom_menu_item language The language menu if created */

    protected $language = null;



    public function custom_menu($custommenuitems = '') {
        global $CFG;
        if (empty($custommenuitems) && !empty($CFG->custommenuitems)) {
            $custommenuitems = $CFG->custommenuitems;
        }
        $custommenu = new custom_menu($custommenuitems, current_language());
        return $this->render_custom_menu($custommenu);
    }

    protected function render_custom_menu(custom_menu $menu) {
        global $CFG;



        $langs = get_string_manager()->get_list_of_translations();
        $haslangmenu = $this->lang_menu() != '';

        if (!$menu->has_children() && !$haslangmenu) {
            return '';
        }

        if ($haslangmenu) {
            $strlang =  get_string('language');
            $currentlang = current_language();
            if (isset($langs[$currentlang])) {
                $currentlang = $langs[$currentlang];
            } else {
                $currentlang = $strlang;
            }
            $this->language = $menu->add($currentlang, new moodle_url(''), $strlang, 10000);
            foreach ($langs as $langtype => $langname) {
                $this->language->add($langname, new moodle_url($this->page->url, array('lang' => $langtype)), $langname);
            }

        }

        $content = '<ul class="navigation-wrapper">';
        foreach ($menu->get_children() as $item) {
            $content .= $this->render_custom_menu_item($item, 1);
        }

        return $content.'</ul>';
    }
    
    protected function render_custom_menu_item(custom_menu_item $menunode, $level = 0 ) {
        global $CFG, $OUTPUT;
        static $submenucount = 0;
        //$flagurl = "$CFG->wwwroot";
        $languages = get_string_manager()->get_list_of_translations();
        $curntlang = current_language();
        $haslangmenuitem = $this->lang_menu() != '';
        $flaglist = $CFG->dirroot . theme_ignite_theme_root_dir() . '/ignite/pix/flags/48x32/' . strtoupper($curntlang) . '.png';
        $isflag = file_exists($flaglist) ? true : false;
        $content = '';

        if ($menunode->has_children()) {

            if ($level == 1) {
                $class = 'nav-dropdown-menu';
            } else {
                $class = 'nav-dropdown-submenu';
            }

            if ($menunode === $this->language) {
                $class .= ' langmenu-item';
            }
            $content = html_writer::start_tag('li', array('class' => $class));
            // If the child has menus render it as a sub menu.
            $submenucount++;
            if ($menunode->get_url() !== null) {
                $url = $menunode->get_url();
            } else {
                $url = '#';
            }
            $content .= html_writer::start_tag('a', array('href'=>$url, 'class'=>'dropdown-item tst', 'role'=>'menuitem', 'data-toggle' => 'dropdown-item', 'title'=>$menunode->get_title()));
            if ($menunode === $this->language){
                $content .= '';
            }else{
                $content .= $menunode->get_text();
            }
            
            if ($level == 1) {
               // $content .= '<strong class="caret-item"></strong>';
                if ($menunode === $this->language){
                    $currentlanguage = current_language();
                    if($isflag){
                        $flaglink = $OUTPUT->image_url('flags/48x32/' . strtoupper($currentlanguage),'theme');
                    }else{
                        $flaglink = $OUTPUT->image_url('flags/48x32/noflag','theme');
                    }
                    $content .= '<span class="lang-flag '.$currentlanguage.'" style="background-image:url(\'' . $flaglink . '\');"></span>';
                    $content .= '<span class="sname">' . $currentlanguage . '</span>';
                    if (isset($languages[$currentlanguage])) {
                        $currentlanguage = $languages[$currentlanguage];
                        $content .= '<span class="fname">'.$currentlanguage.'</span>';
                    }
                }
            }
           
            $content .= '</a>';
            $content .= '<ul class="dropdown-list-item">';
            foreach ($menunode->get_children() as $menunode) {
                $content .= $this->render_custom_menu_item($menunode, 0);
            }
            $content .= '</ul>';
        } else {
            // The node doesn't have children so produce a final menuitem.
            // Also, if the node's text matches '####', add a class so we can treat it as a divider.
            if (preg_match("/^#+$/", $menunode->get_text())) {
                // This is a divider.
                //$content = '<li class="divider">&nbsp;</li>';
            } else {
                $content = '<li>';
                if ($menunode->get_url() !== null) {
                    $url = $menunode->get_url();
                } else {
                    $url = '#';
                }
                //$content .= html_writer::link($url, $menunode->get_text(), array('title' => $menunode->get_title()));

                $content .= html_writer::start_tag('a', array('href'=>$url, 'class'=>'dropdown-item tst', 'title'=>$menunode->get_title()));
                //$c_lang = $menunode->get_parent()->get_parent()->get_currentlang();
                //$c_lang = $menunode->get_parent()->get_parent();


                if ($menunode->get_parent()->get_title() === "Language" /*|| $c_lang !== null*/){
                    $content .= '';
                }else{
                    $content .= $menunode->get_text();
                }
               if($menunode->get_parent()->get_title() === "Language" || $menunode->get_parent()->get_title() !== ""){
                    $langmitem = get_string_manager()->get_list_of_translations();
                    $haslan = $this->lang_menu() != '';
                   if($haslan){
                       $cl = current_language();
                       foreach ($langmitem as $langkey => $langval) {
                           if($menunode->get_text() === $langmitem[$langkey]){
                               if($langkey !== $cl){

                                   $flagitem = $CFG->dirroot . theme_ignite_theme_root_dir() . '/ignite/pix/flags/48x32/' . strtoupper($langkey) . '.png';
                                   $existflag = file_exists($flagitem) ? true : false;

                                   if($existflag){
                                       $flagurl = $OUTPUT->image_url('flags/48x32/' . strtoupper($langkey),'theme');
                                   }else{
                                       $flagurl = $OUTPUT->image_url('flags/48x32/noflag','theme');
                                   }

                                   $content .= '<span class="lang-flag '.$langkey.'" style="background-image:url(\'' . $flagurl . '\');"></span>';
                                   $content .= '<span class="sname">' . $langkey . '</span>';
                                   $content .= '<span class="fname">' . $langval . '</span>';
                               }else{
                                   $content .= '';
                               }


                           }

                       }

                   }

                  // $content .= '<span class="fname">' . $menunode->get_text() . '</span>';

                }
                $content .= '</a>';
                $content .= '</li>';
            }
        }
        return $content;
    }

    public function customlinks() {
        global $PAGE;
        $context = $this->page->context;

        /*
            >>>> custom link heading/tagline Section //Start
        */

            $customlnkmainheading = (empty($PAGE->theme->settings->custom_link_main_heading)) ? false : $PAGE->theme->settings->custom_link_main_heading;

            $customlnkmaintagline = (empty($PAGE->theme->settings->custom_link_main_tagline)) ? false : $PAGE->theme->settings->custom_link_main_tagline;


        /*
            >>>> custom link heading/tagline Section //End
        */

      /*  $customccreation = (empty($PAGE->theme->settings->createicon && isloggedin() && has_capability('moodle/course:create', $context))) ? false : $PAGE->theme->settings->createicon;
         $customcbuttonurl = (empty($PAGE->theme->settings->createbuttonurl)) ? false : $PAGE->theme->settings->createbuttonurl;
        $customcbuttontext = (empty($PAGE->theme->settings->createbuttontext)) ? false : format_string($PAGE->theme->settings->createbuttontext);*/

  
        $customlink1icon = (empty($PAGE->theme->settings->custom_link_one)) ? false : $PAGE->theme->settings->custom_link_one;
        $customlink2icon = (empty($PAGE->theme->settings->custom_link_two)) ? false : $PAGE->theme->settings->custom_link_two;
        $customlink3icon = (empty($PAGE->theme->settings->custom_link_three)) ? false : $PAGE->theme->settings->custom_link_three;
        $customlink4icon = (empty($PAGE->theme->settings->custom_link_four)) ? false : $PAGE->theme->settings->custom_link_four;
        $customlink5icon = (empty($PAGE->theme->settings->custom_link_five)) ? false : $PAGE->theme->settings->custom_link_five;
        $customlink6icon = (empty($PAGE->theme->settings->custom_link_six)) ? false : $PAGE->theme->settings->custom_link_six;
        $customlink7icon = (empty($PAGE->theme->settings->custom_link_seven)) ? false : $PAGE->theme->settings->custom_link_seven;
        $customlink8icon = (empty($PAGE->theme->settings->custom_link_eight)) ? false : $PAGE->theme->settings->custom_link_eight;


        $customlink1url = (empty($PAGE->theme->settings->custom_link_one_url)) ? false : $PAGE->theme->settings->custom_link_one_url;
        $customlink2url = (empty($PAGE->theme->settings->custom_link_two_url)) ? false : $PAGE->theme->settings->custom_link_two_url;
        $customlink3url = (empty($PAGE->theme->settings->custom_link_three_url)) ? false : $PAGE->theme->settings->custom_link_three_url;
        $customlink4url = (empty($PAGE->theme->settings->custom_link_four_url)) ? false : $PAGE->theme->settings->custom_link_four_url;
        $customlink5url = (empty($PAGE->theme->settings->custom_link_five_url)) ? false : $PAGE->theme->settings->custom_link_five_url;
        $customlink6url = (empty($PAGE->theme->settings->custom_link_six_url)) ? false : $PAGE->theme->settings->custom_link_six_url;
        $customlink7url = (empty($PAGE->theme->settings->custom_link_seven_url)) ? false : $PAGE->theme->settings->custom_link_seven_url;
        $customlink8url = (empty($PAGE->theme->settings->custom_link_eight_url)) ? false : $PAGE->theme->settings->custom_link_eight_url;


        $customlink1text = (empty($PAGE->theme->settings->custom_link_text_one)) ? false : format_string($PAGE->theme->settings->custom_link_text_one);
        $customlink2text = (empty($PAGE->theme->settings->custom_link_text_two)) ? false : format_string($PAGE->theme->settings->custom_link_text_two);
        $customlink3text = (empty($PAGE->theme->settings->custom_link_text_three)) ? false : format_string($PAGE->theme->settings->custom_link_text_three);
        $customlink4text = (empty($PAGE->theme->settings->custom_link_text_four)) ? false : format_string($PAGE->theme->settings->custom_link_text_four);
        $customlink5text = (empty($PAGE->theme->settings->custom_link_text_five)) ? false : format_string($PAGE->theme->settings->custom_link_text_five);
        $customlink6text = (empty($PAGE->theme->settings->custom_link_text_six)) ? false : format_string($PAGE->theme->settings->custom_link_text_six);
        $customlink7text = (empty($PAGE->theme->settings->custom_link_text_seven)) ? false : format_string($PAGE->theme->settings->custom_link_text_seven);
        $customlink8text = (empty($PAGE->theme->settings->custom_link_text_eight)) ? false : format_string($PAGE->theme->settings->custom_link_text_eight);
 

     
     
        
        
        

        $logintoken = \core\session\manager::get_login_token();

        $custom_link_icon_data = ['logintoken' => $logintoken,
        // If any of the above social networks are true, sets this to true.
        'combolisticon' => ($customlnkmaintagline || $customlnkmainheading || $customlink1icon || $customlink2icon || $customlink3icon || $customlink4icon || $customlink5icon || $customlink6icon || $customlink7icon || $customlink8icon /*|| $customccreation*/) ? true : false, 'bundleicons' => array(
            array(
                'comboicon' => $customlink1icon,
                'linkicon' => $customlink1icon,
                'link' => $customlink1url,
                'linktext' => $customlink1text
            ) ,
            array(
                'comboicon' => $customlink2icon,
                'linkicon' => $customlink2icon,
                'link' => $customlink2url,
                'linktext' => $customlink2text
            ) ,
            array(
                'comboicon' => $customlink3icon,
                'linkicon' => $customlink3icon,
                'link' => $customlink3url,
                'linktext' => $customlink3text
            ) ,
            array(
                'comboicon' => $customlink4icon,
                'linkicon' => $customlink4icon,
                'link' => $customlink4url,
                'linktext' => $customlink4text
            ) ,
            array(
                'comboicon' => $customlink5icon,
                'linkicon' => $customlink5icon,
                'link' => $customlink5url,
                'linktext' => $customlink5text
            ) ,
            array(
                'comboicon' => $customlink6icon,
                'linkicon' => $customlink6icon,
                'link' => $customlink6url,
                'linktext' => $customlink6text
            ) ,
            array(
                'comboicon' => $customlink7icon,
                'linkicon' => $customlink7icon,
                'link' => $customlink7url,
                'linktext' => $customlink7text
            ),
            array(
                'comboicon' => $customlink8icon,
                'linkicon' => $customlink8icon,
                'link' => $customlink8url,
                'linktext' => $customlink8text
            )
            
        ) ,

        'customlnkheadtag' => array(

            array(

                'customlnkheading' => $customlnkmainheading,
                'customlnktagline' => $customlnkmaintagline
            ),

        ),

        ];
        return $this->render_from_template('theme_ignite/customlinks', $custom_link_icon_data);
    }

}

