<?php

defined('MOODLE_INTERNAL') || die();

/**
 * Get SCSS to prepend.
 *
 * @param theme_config $theme The theme config object.
 * @return array
 */

/*
 ====>>> SCSS/Styling custom invocation Start
*/

function theme_ignite_get_pre_scss($theme) {

    /*>>> Global Variable>>*/

    global $CFG;   $scss = '';

    /*>>>General Array List Start>>*/

    $configurable = [
        /*>>> Config key => [variableName, ...]>> */

        'brandcolor' => ['primary'],
    ];

    $commonarrlist = [
        /*>>> Font Family List - Config key => [variableName, ...]>> */

        'body_font_face' => ['body_font_face'],
        /*>>> Font Size List>> */
        'body_font_size' => ['body_font_size', 'px'],
        /*>>> Font Style List>> */
        'font_weight_common' => ['font_weight_common'],
        /*>>> Heading Font Family>> */
        'font_heading' => ['font_heading'],
        /*>>> Heading Size List Start>> */
        'font_size_heading_One' => ['font_size_heading_One', 'rem'],
        'font_size_heading_Two' => ['font_size_heading_Two', 'rem'],
        'font_size_heading_Three' => ['font_size_heading_Three', 'rem'],
        'font_size_heading_Four' => ['font_size_heading_Four', 'rem'],
        'font_size_heading_Five' => ['font_size_heading_Five', 'rem'],
        'font_size_heading_Six' => ['font_size_heading_Six', 'rem'],
        /*>>> Heading Size List End>> */
        /*>>> Heading Font Weight>> */
        'font_weight_heading' => ['font_weight_heading'],
        /*>>> Heading Fonts Text Transform>> */
        'heading_text_transform' => ['heading_text_transform'],
        /*>>> Heading Fonts Style>> */
        'heading_font_style' => ['heading_font_style'],
        /*>>> Colours Settings>> */
        /*>>> Navigation/menu Font's Properties //Start>>*/
        'nav_font_face' => ['nav_font_face'],
        'nav_font_size' => ['nav_font_size', 'rem'],
        'nav_font_weight' => ['nav_font_weight'],
        'nav_font_transform' => ['nav_font_transform'],
        'nav_font_style' => ['nav_font_style'],
        /*>>> Navigation/menu Font's Properties //End>>*/
        'gradient_start' => ['gradient_start'],
        'gradient_end' => ['gradient_end'],
        'site_news_gradient_start' => ['site_news_gradient_start'],
        'site_news_gradient_end' => ['site_news_gradient_end'],
        'tutor_gradient_start' => ['tutor_gradient_start'],
        'tutor_gradient_end' => ['tutor_gradient_end'],
        'theader_icon_bg' => ['theader_icon_bg'],
        'theader_icon_color'=>['theader_icon_color'],
        'theader_border_color' => ['theader_border_color'],
        'theme_primary_color' => ['theme_primary_color'],
        'theme_secondary_color' => ['theme_secondary_color'],
        'theme_tertiary_color' => ['theme_tertiary_color'],
        'site_oragnge_color' => ['site_oragnge_color'],
        'site_cyan_color' => ['site_cyan_color'],
        'site_light_blue_color' => ['site_light_blue_color'],
        'site_pursian_blue_color' => ['site_pursian_blue_color'],
        'site_purple_color' => ['site_purple_color'],
        'site_green_color' => ['site_green_color'],
        'site_pink_color' => ['site_pink_color'],
        'site_red_color' => ['site_red_color'],
        'default_button_color' => ['default_button_color'],
        'default_button_hover_color' => ['default_button_hover_color'],
        'menu_color' => ['menu_color'],
        'menu_hover_color' => ['menu_hover_color'],
        'g_white_color' => ['g_white_color'],
        'g_black_color' => ['g_black_color'],
        'fp_banner_bg__color' => ['fp_banner_bg__color'],
        'fp_banner_heading__color' => ['fp_banner_heading__color'],
        'fp_banner_tagline__color' => ['fp_banner_tagline__color'],
        'fp_banner_global__color' => ['fp_banner_global__color'],
        'fp_newsletter_heading__color' => ['fp_newsletter_heading__color'],
        'section_heading_color' => ['section_heading_color'],
        'section_tagline_color' => ['section_tagline_color'],
        'custom_link_tab_color' => ['custom_link_tab_color'],
        'custom_link_tab_hov_color' => ['custom_link_tab_hov_color'],
        'custom_cat_bg_color' => ['custom_cat_bg_color'],
        'grey_100' => ['grey_100'],
        'grey_200' => ['grey_200'],
        'grey_300' => ['grey_300'],
        'grey_400' => ['grey_400'],
        'grey_500' => ['grey_500'],
        'grey_600' => ['grey_600'],
        'grey_700' => ['grey_700'],
        'grey_800' => ['grey_800'],
        'footer_top_style_1_color' => ['footer_top_style_1_color'],
        'footer_bottom_style_1_color' => ['footer_bottom_style_1_color']
    ];

    /*>>>General Array List End>>*/

    /*>>>Prepend variables first>>*/

    foreach ($configurable as $configkey => $targets) {

        $value = isset($theme->settings->{$configkey}) ? $theme->settings->{$configkey} : null;

        if (empty($value)) {
            continue;
        }

        array_map(function($target) use (&$scss, $value) {
            $scss .= '$' . $target . ': ' . $value . ";\n";
        }, (array) $targets);

    }

    /*
     >>> Font's settings & other general settings
    */

    foreach ($commonarrlist as $commonkeylist => $commonkeylistval){

        switch ($commonkeylist)

        {
            case ('body_font_face') :

                $fontName = $theme->settings->body_font_face;
                $issetvar = (isset($theme->settings->$fontName) && $theme->settings->$fontName !='')  
                ? '\'' . $theme->settings->$fontName . '\'' : NULL;
                break;

            case ('body_font_size') :

            $fsizekey = $theme->settings->body_font_size;

            if ($fsizekey == "0") {
                 $issetvar = '12';
            } else if ($fsizekey =="1"){
                 $issetvar = '13';
            } else if ($fsizekey =="2"){
                 $issetvar = '14';
            } else if ($fsizekey =="3"){
                 $issetvar = '15';
            } else if ($fsizekey =="4"){
                 $issetvar = '16';
            }

            break;

            case ('font_heading') : 

            $fontName = $theme->settings->font_heading;
                $issetvar = (isset($theme->settings->$fontName) && $theme->settings->$fontName !='')  
                ? '\'' . $theme->settings->$fontName . '\'' : NULL;
                break;

            case ('nav_font_face') : 

            $fontName = $theme->settings->nav_font_face;
                $issetvar = (isset($theme->settings->$fontName) && $theme->settings->$fontName !='')  
                ? '\'' . $theme->settings->$fontName . '\'' : NULL;
                break;   

            default :

            $issetvar = (isset($theme->settings->$commonkeylist) && $theme->settings->$commonkeylist !='') ? $theme->settings->$commonkeylist : NULL;

        }


        /*>>>Check variable existence>>*/
        if($issetvar != "'none'"){

            if (!empty($issetvar))

                {
                    $issetfx = isset($commonkeylistval[1]) ? $commonkeylistval[1] : '';
                    $scss .= '$' . $commonkeylistval[0] . ':' . $issetvar . $issetfx . ';';
                }
        }
        
    }


    /*>>>Prepend pre-scss>>*/

    if (!empty($theme->settings->scsspre)) {
        $scss .= $theme->settings->scsspre;
    }

    if (!empty($theme->settings->fontsize)) {
        $scss .= '$font-size-base: ' . (1 / 100 * $theme->settings->fontsize) . "rem !default;\n";
    }

    return $scss;
}

/*
 ====>>> SCSS/Styling custom invocation End
*/
/*
 function theme_ignite_get_extra_scss_raw($theme){

    global $PAGE;
    $output = '';
    
    $output .= theme_ignite_custom_web_fonts();

    return $output;
 }*/