<?php


defined('MOODLE_INTERNAL') || die();

/**
 * Serves any files associated with the theme settings.
 *
 * @param stdClass $course
 * @param stdClass $cm
 * @param context $context
 * @param string $filearea
 * @param array $args
 * @param bool $forcedownload
 * @param array $options
 * @return bool
 */
function theme_ignite_pluginfile($course, $cm, $context, $filearea, $args, $forcedownload, array $options = array()) {

    $coursecats = core_course_category::make_categories_list();

    if ($context->contextlevel == CONTEXT_SYSTEM)
    {
        $theme = theme_config::load('ignite');

        switch ($filearea){

            case 'logo' :
                return $theme->setting_file_serve('logo', $args, $forcedownload, $options);
                break;

            case 'footerlogo' :
                return $theme->setting_file_serve('footerlogo', $args, $forcedownload, $options);
                break;

            case 'backgroundimage' :
                return $theme->setting_file_serve('backgroundimage', $args, $forcedownload, $options);
                break;

            case 'customfontfiles1' :
                return $theme->setting_file_serve('customfontfiles1', $args, $forcedownload, $options);
                break;

            case 'customfontfiles2' :
                return $theme->setting_file_serve('customfontfiles2', $args, $forcedownload, $options);
                break;

            case 'customfontfiles3' :
                return $theme->setting_file_serve('customfontfiles3', $args, $forcedownload, $options);
                break;

            case 'customfontfiles4' :
                return $theme->setting_file_serve('customfontfiles4', $args, $forcedownload, $options);
                break;

            case 'customfontfiles5' :
                return $theme->setting_file_serve('customfontfiles5', $args, $forcedownload, $options);
                break;

            case 'defaultcateimage' :
                return $theme->setting_file_serve('defaultcateimage', $args, $forcedownload, $options);
                break;

            case 'preloader_image' :
                return $theme->setting_file_serve('preloader_image', $args, $forcedownload, $options);
                break;   

            default :
                send_file_not_found();
        }
    }else {
        send_file_not_found();
    }





    /*if ($context->contextlevel == CONTEXT_SYSTEM && ($filearea === 'logo' || $filearea === 'backgroundimage')) {
        $theme = theme_config::load('ignite');
        // By default, theme files must be cache-able by both browsers and proxies.
        if (!array_key_exists('cacheability', $options)) {
            $options['cacheability'] = 'public';
        }
        return $theme->setting_file_serve($filearea, $args, $forcedownload, $options);
    } else {
        send_file_not_found();
    }*/
}