<?php


defined('MOODLE_INTERNAL') || die();


/*
    ==========================
        ======================== This function/method is used for checking Moodle's default login page //START============
*/
/*function theme_ignite_moodle_login($page, $custom = false)
{

	$output = false;
	$pageTypeArr = explode('-', $page->pagetype);
	$loginPage = ($pageTypeArr[0] === 'login' && $pageTypeArr[1] === 'index');
	$customLoginPage = theme_ignite_moodle_theme_setting($page, 'cloginpage', '', 0);
	$isuserLogged = (isloggedin() && !isguestuser());

	if ( $custom )
	{
		$output = ( $loginPage && $customLoginPage && ! $isuserLogged );
	}
	else
	{
		$output = $loginPage;
	}

	return $output;

}*/

/*
    ==========================
        ======================== This function/method is used for checking Moodle's default login page //END============
*/


/*
    ==========================
        ======================== This function/method is used for getting theme's setting //START============
*/
function theme_ignite_moodle_theme_setting ($page, $name, $default = '', $image = false, $theme= false)
{
	if ($theme)
	{
		if (!empty($theme->settings->$name))
		{
			if ($image === true)
			{
				$output = $theme->setting_file_url($name, $name);
			}
			else
			{
				$output = $theme->settings->$name;
			}
		}
		else
		{
			$output = $default;
		}
	}
	else
	{
		if (!empty($page->theme->settings->$name))
		{

			if ($image === true)
			{
				$output = $page->theme->setting_file_url($name, $name);
			}
			else
			{
				$output = $page->theme->settings->$name;
			}
		}
		else
		{
			$output = $default;
		}
	}

	return $output;

}

/*
    ==========================
        ======================== This function/method is used for getting theme's setting //END============
*/

/*
    ==========================
        ======================== This function/method is used for getting Moodle's version //Start============
*/
function theme_ignite_moodle_from ($version)
{
	global $CFG;

	if ($CFG->version >= $version)
	{
		return true;
	}

	return false;
}

/*
    ==========================
        ======================== This function/method is used for getting Moodle's version //END============
*/

/*
    ==========================
        ======================== This function/method is used for modifying template's structure //Strart============
*/
function theme_ignite_course_layout_modifier()
{
	global $PAGE;
	$output = '';
	$iscoursefrontpage = ($PAGE->pagetype === 'site-index' && theme_ignite_moodle_theme_setting($PAGE, 'frontpagecoursegrid'));
	$grid_view_active = '';
	$list_view_active = ' active';

	if ($iscoursefrontpage)
	{
		$grid_view_active = ' active';
		$list_view_active = '';
	}

	$output .= '<div class="course-layout-modifier">';
	$output .= '<a href="#" class="grid-view' . $grid_view_active . '" title="grid-view" data-toggle="tooltip" data-trigger="hover"><i class="fa fa-th-large"></i></a>';
	$output .= '<a href="#" class="list-view' . $list_view_active . '" title="list-view" data-toggle="tooltip" data-trigger="hover"><i class="fa fa-th-list"></i></a>';
	$output .= '</div>';

	return $output;

}

/*
    ==========================
        ======================== This function/method is used for modifying template's structure //End============
*/

/*
    ==========================
        ======================== This function/method is used for getting theme's root directory //Start============
*/
function theme_ignite_theme_root_dir ()
{
	global $CFG;

	$theme_dir = '/theme';

	if (isset($CFG->themedir))
	{
		$theme_dir = $CFG->themedir;
		$theme_dir = str_replace($CFG->dirroot, '', $CFG->themedir);
	}

	return $theme_dir;

}

/*
    ==========================
        ======================== This function/method is used for getting theme's root directory //End============
*/

/*
    ==========================
        ======================== This function/method is used for getting font's icon //Start============
*/
function theme_ignite_custom_styling_files( $page)
{

	$page->requires->css( theme_ignite_theme_root_dir() . '/ignite/assets/social-icons.css');

}
/*
    ==========================
        ======================== This function/method is used for getting font's icon //End============
*/

/*
    ==========================
        ======================== This function/method is used for getting files from file area //Start============
*/

function theme_ignite_filearea( $filearea = '', $image = true )
{

	if ( ! $filearea )
	{
		return;
	}

	$context = context_system::instance();
	$url = '';
	$urls = array();
	$i = 0;
	$fs = get_file_storage();
	$files = $fs->get_area_files($context->id, 'theme_ignite', $filearea );

	foreach ($files as $f)
	{
		$checkimage = $image ? $f->is_valid_image() : $f->get_filename() !== '.';

		if ( $checkimage )
		{
			$i++;
			$sep = $i > 1 ? ',' : '';
			$url .= $sep . moodle_url::make_pluginfile_url($f->get_contextid(), $f->get_component(), $f->get_filearea(), $f->get_itemid(), $f->get_filepath(), $f->get_filename());
		}
	 }

	 $urls = explode( ',', $url );
	 $urls = array_filter($urls);

	 return $urls;

}
/*
    ==========================
        ======================== This function/method is used for getting files from file area //End============
*/

/*
    ==========================
        ======================== This function/method is used for getting theme's name //Start============
*/
function theme_ignite_themename ()
{
	global $CFG,$PAGE,$COURSE;

	$name = $CFG->theme;

	if (isset($PAGE->theme->name) && $PAGE->theme->name)
	{
		$name = $PAGE->theme->name;
	}
	elseif (isset($COURSE->theme) && $COURSE->theme)
	{
		$name = $COURSE->theme;
	}

	return $name;

}

/*
    ==========================
        ======================== This function/method is used for getting theme's name //End============
*/

/*
    ==========================
        ======================== This function/method is used for getting logo's URL //Start============
*/
function theme_ignite_logo_url($page)
{

	global $OUTPUT;
	$checkCustomLogo = '';
	$corelogo = $OUTPUT->image_url('corelogo','theme');

	if(theme_ignite_moodle_theme_setting($page,'logo','', true) != ''){

		$checkCustomLogo = theme_ignite_moodle_theme_setting($page,'logo','', true);
	}

	$logoUrl = $checkCustomLogo !='' ? $checkCustomLogo : $corelogo;

	return $logoUrl;

}

/*
    ==========================
        ======================== This function/method is used for getting logo's URL //End============
*/
/*
    ==========================
        ======================== This function/method is used for getting to check if user has role //Start============
*/
function theme_ignite_has_user_role($courseid, $roleid, $userid = 0)
{

	 $user_roles = get_user_roles(context_course::instance($courseid), $userid, false);

	 foreach ($user_roles as $user_role)
	 {
		  if ($user_role->roleid == $roleid)
		  {
			  return true;
		  }
	 }

    return false;
}

/*
    ==========================
        ======================== This function/method is used for getting to check if user has role //End============
*/

/*
    ==========================
        ======================== This function/method is used for getting to display show/hide buttons//Start============
*/


       function show_hide_sidestrip_button($page, $vars = array()){
       		$output = '';
       		$class = '';
       		$sidestripbtn = theme_ignite_moodle_theme_setting($page, 'side_strip_btn');
       		$sidestripbtntext = theme_ignite_moodle_theme_setting($page, 'side_strip_btn_text');
       		$class.= ($sidestripbtntext == 1) ? "striptext__btn" : "stripicon__btn";

       		if($sidestripbtn == 1){
       			if($sidestripbtntext == 1){
       				$output .= '<a href="javascript:void(0)" class="ignite_sidestrip__btn ' . $class . '" data-hide="' . get_string('hidesidestriptxt','theme_ignite') . '" data-show="' . get_string('showsidestriptxt','theme_ignite') . '">'.get_string('hidesidestriptxt','theme_ignite').'</a>';
       			}else{
       				$output .= '<a href="javascript:void(0)" class="ignite_sidestrip__btn ' . $class . '" data-hide="' . get_string('hidesidestriptxt','theme_ignite') . '" data-show="' . get_string('showsidestriptxt','theme_ignite') . '"><i class="fa fa-bars fa-rotate-180"></i></a>';
       			}
       			

       		}else if($sidestripbtn == 0){
       			return;
       		}

       		return $output;
       }

 /*
    ==========================
        ======================== This function/method is used for getting to display show/hide buttons//End============
*/



