jQuery(document).ready(function ($) {
    $('.theme-ddmenu').each(function () {
        var menuList = $(this),
            animType = menuList.data('animtype'),
            animSpeed = menuList.data('animspeed'),
            mobileArr = menuList.find('.caret-item');
        menuList.superfish({
            popUpSelector: 'ul',
            hoverClass: 'ignite-hover',
            animation: animType == 2 ? {
                height: 'show'
            } : {
                opacity: 'show'
            },
            speed: animSpeed,
            speedOut: 'fast',
            cssArrows: false
        });
        menuOnHover(menuList);
        $(window).on('resize', function () {
            menuOnHover(menuList)
        });
        mobileArr.click(function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            $(this).parent().siblings('ul').slideToggle(250);
            $(this).toggleClass('active')
        })

        function menuOnHover(list) {
            var aTag = list.find("li:not(.langmenu-item) a");
            var cn = "menu-active",
                mt = "menu-text",
                cs = {
                    expires: 7,
                    path: "/"
                },
                msc = {
                    expires: 7,
                    path: "/"
                };
            if(Cookies.get(cn) === "active"){
                if(!$("body").hasClass("pagelayout-frontpage")){
                    if(list.find("li a.active")){
                        $(".tst.active").removeClass("active");
                    }
                    aTag.each(function(index, node){
                        menuTxtNode = $(node)[0].innerText;
                        if(menuTxtNode.indexOf(Cookies.get(mt)) > -1){
                            if(!$(this).hasClass('active'))
                            {
                                $(".tst.active").removeClass("active");
                                $(this).addClass("active");
                            }
                        }
                    });
                }
            }
            aTag.click(function(){
                var menuTxt = $(this)[0].innerHTML || $(this)[0].innerText;
                var menuCapTxt = menuTxt.toUpperCase();
                if(!$(this).hasClass('active'))
                {
                    $(".tst.active").removeClass("active");
                    $(this).addClass("active");
                    Cookies.remove(cn);
                    Cookies.remove(mt);
                    Cookies.set(cn, "active", cs);
                    Cookies.set(mt, menuCapTxt, msc);
                }
            });
            var w = (window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth);
            if (w <= 960) {
                list.removeClass('sf-js-enabled');
                list.removeClass('desk-menu');
                list.addClass('mobile-menu')
            } else {
                list.addClass('sf-js-enabled');
                list.removeClass('mobile-menu');
                list.addClass('desk-menu');
                list.find('.caret-item').removeClass('active');
                list.find('.caret-item').parent().siblings('ul').hide()
            }
        }
    });

    function customAccordion(header, content) {
        header.click(function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            $(this).toggleClass('active');
            content.slideToggle(250)
        })
    };
    $(document).on('click', '.show-menu', function (e) {
        e.preventDefault();
        e.stopImmediatePropagation();
        var menuList = $(this).parent().parent().parent().find('.navigation-main-wrapper').find('.theme-ddmenu');
        menuList.slideToggle(250)
    });

    /*=====
    ======= fixed navigation start======*/

    setTimeout(function () {
        makeFixedNavigation()
    }, 10);
    $(window).scroll(function () {
        makeFixedNavigation();
    });

    function makeFixedNavigation() {
        var win = $(window),
            offsetEl = $('.fixed-nav-element');
        if (offsetEl.length != 0 && $('body').hasClass('fixed-nav')) {
            var fixedEl = $('#nav-main'),
                fixedElWrap = fixedEl.parent(),
                elOffset = offsetEl.offset().top,
                fixElHeight = fixedEl.outerHeight(true);
            if (win.scrollTop() > elOffset) {
                $("body").addClass("fixed_nav__bar");
                fixedEl.addClass('navbar-fixed-top');
                offsetEl.css({
                    height: fixElHeight
                })
            } else {
                fixedEl.removeClass('navbar-fixed-top');
                $("body").removeClass("fixed_nav__bar");
                offsetEl.css({
                    height: 0
                })
            }
        }
    };

    /*=====
    ======= fixed navigation end======*/

    /*=====
    ======= Message App Drawer Close Button Start======*/



       if(($(".drawer[data-region='right-hand-drawer']").length === 1)){
            if($(".drawer[data-region='right-hand-drawer'] .close-btn").length === 0){
                $( "<div class='custom-button-section'><a href='javascript:void(0)' class='close-btn'><i class='cb-cross-icon'></i></a></div>" ).insertBefore( ".drawer[data-region='right-hand-drawer'] div[data-region='header-container']" );
            }
        }



    if($(".drawer[data-region='right-hand-drawer']").length > 0){
        if(($(".drawer[data-region='right-hand-drawer'] .custom-button-section a.close-btn").length === 1)){
            $(".drawer[data-region='right-hand-drawer'] .custom-button-section a.close-btn").on("click", function(){
                $(".drawer[data-region='right-hand-drawer']").addClass("hidden");
                $(".drawer[data-region='right-hand-drawer']").attr({
                    "aria-expanded":"false",
                    "aria-hidden":"true"
                });
            });
        }
    }


    /*=====
    ======= Message App Drawer Close Button End======*/

    /*=====
    ======= Message App Drawer Contacts and Settings Button Moved Start======*/


    if($(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div a[data-route='view-settings']").length > 0){
        if($(".drawer[data-region='right-hand-drawer'] .custom-button-section a.close-btn").length > 0){
             $(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div a[data-route='view-settings']").insertAfter($(".message-app .custom-button-section a.close-btn"));
        }
    }

    if($(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div a[data-route='view-contacts']").length > 0){
        if($(".drawer[data-region='right-hand-drawer'] .custom-button-section a[data-route='view-settings']").length > 0){
             $(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div a[data-route='view-contacts']").insertAfter($(".message-app .custom-button-section a[data-route='view-settings']"));
        }
    }


    /*=====
    ======= Message App Drawer Contacts and Settings Button Moved End======*/

    /*=====
    ======= Message App Drawer Settings Search Moved Start======*/

    if($(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div div.input-group").length > 0){

        if($(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div div.input-group .input-group-prepend").length > 0){

            if($(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div div.input-group input[data-region='view-overview-search-input']").length > 0){
                $(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div div.input-group .input-group-prepend").insertAfter($(".drawer[data-region='right-hand-drawer'] .header-container div[data-region='view-overview'] div div.input-group  input[data-region='view-overview-search-input']"));
            }
        }

    }

    /*=====
    ======= Message App Drawer Settings Search Moved End======*/

});
