<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Parent theme: boost
 *
 * @package   theme_edvik
 * @copyright HiBootstrap
 *
 */

namespace theme_edvik\output;

use action_link;
use action_menu;
use action_menu_filler;
use action_menu_link_secondary;
use block_contents;
use block_move_target;
use coding_exception;
use context_course;
use context_system;
use core_text;
use custom_menu;
use custom_menu_item;
use html_writer;
use moodle_page;
use moodle_url;
use navigation_node;
use pix_icon;
use stdClass;

defined('MOODLE_INTERNAL') || die;

/**
 * Renderers to align Moodle's HTML with that expected by Bootstrap
 *
 * @package    theme_edvik
 * @copyright  2023 HiBootstrap
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class core_renderer extends \core_renderer {


    /**
   * Return the image URL, if any.
   *
   * Note that maximum sizes are not applied to the image.
   *
   * @param int $maxwidth The maximum width, or null when the maximum width does not matter.
   * @param int $maxheight The maximum height, or null when the maximum height does not matter.
   * @return moodle_url|false
   */
    public function get_theme_image_main_logo($maxwidth = null, $maxheight = 100) {
        global $CFG;
        if (!empty($this->page->theme->settings->main_logo)) {
            $url = $this->page->theme->setting_file_url('main_logo', 'main_logo');
            // Get a URL suitable for moodle_url.
            $relativebaseurl = preg_replace('|^https?://|i', '//', $CFG->wwwroot);
            $url = str_replace($relativebaseurl, '', $url);
            return new moodle_url($url);
            return parent::get_theme_image_main_logo($maxwidth, $maxheight);
        }
    }


    public function site_url() {
        global $CFG;
        return $CFG->wwwroot;
    }

    public function get_theme_image_mobile_logo($maxwidth = null, $maxheight = 100) {
        global $CFG;
        if (!empty($this->page->theme->settings->mobile_logo)) {
            $url = $this->page->theme->setting_file_url('mobile_logo', 'mobile_logo');
            // Get a URL suitable for moodle_url.
            $relativebaseurl = preg_replace('|^https?://|i', '//', $CFG->wwwroot);
            $url = str_replace($relativebaseurl, '', $url);
            return new moodle_url($url);
            return parent::get_theme_image_mobile_logo($maxwidth, $maxheight);
        }
    }

    public function get_theme_image_main_footer_logo($maxwidth = null, $maxheight = 100) {
        global $CFG;
        if (!empty($this->page->theme->settings->main_footer_logo)) {
            $url = $this->page->theme->setting_file_url('main_footer_logo', 'main_footer_logo');
            // Get a URL suitable for moodle_url.
            $relativebaseurl = preg_replace('|^https?://|i', '//', $CFG->wwwroot);
            $url = str_replace($relativebaseurl, '', $url);
            return new moodle_url($url);
            return parent::get_theme_image_main_footer_logo($maxwidth, $maxheight);
        }
    }

    public function get_theme_image_banner_bg_image($maxwidth = null, $maxheight = 100) {
        global $CFG;
        if (!empty($this->page->theme->settings->banner_bg_image)) {
            $url = $this->page->theme->setting_file_url('banner_bg_image', 'banner_bg_image');
            // Get a URL suitable for moodle_url.
            $relativebaseurl = preg_replace('|^https?://|i', '//', $CFG->wwwroot);
            $url = str_replace($relativebaseurl, '', $url);
            return new moodle_url($url);
            return parent::get_theme_image_banner_bg_image($maxwidth, $maxheight);
        }
    }

    /**
     * Footer Newsletter
     *
     */
    public function edvik_footer_newsletter() {
        global $CFG;

        $fNewslatter       = theme_edvik_get_setting('fNewslatter', 'format_html');
        $fn_top_title       = theme_edvik_get_setting('fn_top_title',  'format_html');
        $fn_title           = theme_edvik_get_setting('fn_title',  'format_html');
        $fn_content         = theme_edvik_get_setting('fn_content',  'format_html');
        $fn_action_url      = theme_edvik_get_setting('fn_action_url',  'format_text');
        $fn_placeholder     = theme_edvik_get_setting('fn_placeholder',  'format_html');
        $fn_btn             = theme_edvik_get_setting('fn_btn',  'format_html');
        $fn_ts_img          = $this->page->theme->setting_file_url('fn_title_shape_img', 'fn_title_shape_img');
        $fn_img             = $this->page->theme->setting_file_url('fn_img', 'fn_img');
        $fn_s_img           = $this->page->theme->setting_file_url('fn_shape_img', 'fn_shape_img');
        $fn_bg_img          = $this->page->theme->setting_file_url('fn_bg_img', 'fn_bg_img');
        ob_start();
            if($fNewslatter == '1'):
                if($fn_bg_img):
                    ?>
                    <style>
                            .newsletter-box:after {
                                background-image: url(<?php echo $fn_bg_img; ?>);
                            }
                    </style>
                    <?php
                endif;
                ?>
                <div class="container">
                    <div class="newsletter-box position-relative index-1">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <div class="newsletter-content">
                                    <div class="section-title style-three">
                                        <span class="fs-13 d-block font-medium text_primary"><?php echo $fn_top_title; ?></span>

                                        <h2 class="d-inline-block font-semibold position-relative">
                                            <?php echo $fn_title; ?>
                                            <?php if($fn_ts_img): ?>
                                                <img src="<?php echo $fn_ts_img; ?>" alt="Shape" class="position-absolute bottom-0 end-0">
                                            <?php endif; ?>
                                        </h2>

                                        <p><?php echo $fn_content; ?></p>
                                    </div>

                                    <?php if($fn_placeholder): ?>
                                        <form action="<?php echo $fn_action_url; ?>" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="newsletter-form validate subscribe-form position-relative" target="_blank">
                                            <input type="text" value="" name="EMAIL" class="email input-newsletter w-100 fs-14 bg-white border-0 round-10" id="mce-EMAIL" placeholder="<?php echo $fn_placeholder; ?>" required>
                                            <button type="submit" name="subscribe" id="mc-embedded-subscribe" class="btnn style-one position-absolute top-0 end-0 h-100 bg_primary text-white border-0 fs-15 round-10"><?php echo $fn_btn; ?><i class="ri-arrow-right-line"></i></button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="newsletter-img-wrap position-relative index-1">

                                    <?php if($fn_s_img): ?>
                                        <img src="<?php echo $fn_s_img; ?>" alt="Shape" class="newsletter-shape position-absolute bounce">
                                    <?php endif; ?>

                                    <?php if($fn_img): ?>
                                        <img src="<?php echo $fn_img; ?>" alt="Shape" class="newsletter-img position-relative d-block mx-auto">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            endif;
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }

    /**
     * Renders the lang menu
     *
     * @return mixed
     */
    public function render_lang_menu() {
        $langs = get_string_manager()->get_list_of_translations();
        $haslangmenu = $this->lang_menu() != '';
        $menu = new custom_menu;

        if ($haslangmenu) {
            $strlang = get_string('language');
            $currentlang = current_language();
            if (isset($langs[$currentlang])) {
                $currentlang = $langs[$currentlang];
            } else {
                $currentlang = $strlang;
            }
            $this->language = $menu->add($currentlang, new moodle_url('#'), $strlang, 10000);
            foreach ($langs as $langtype => $langname) {
                $this->language->add($langname, new moodle_url($this->page->url, array('lang' => $langtype)), $langname);
            }

            foreach ($menu->get_children() as $item) {
                $context = $item->export_for_template($this);
            }

            if (isset($context)) {
                return $this->render_from_template('theme_edvik/lang_menu', $context);
            }
        }
    }

    /**
     * if blog page
     *
     * @return string
     */
    public function if_blog() {
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        if ( strpos($actual_link, '/blog') != false ):
            return true;
        endif;
    }

    /**
     * Current user
     *
     * @return string
     */
    public function edvik_is_siteadmin() {
        if(is_siteadmin()){
            return 'site-admin-active';
        }
    }

    /**
     * if course page
     *
     * @return string
     */
    public function if_course() {
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        if ( strpos($actual_link, 'index.php?categoryid') != false ):
            return true;
        endif;
    }

    /**
     * if home pages
     *
     * @return string
     */
    public function if_home_pages() {
        global $CFG;
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        $hide_banner            = get_config('theme_edvik', 'hide_banner');
        $hide_global_banner     = get_config('theme_edvik', 'hide_global_banner');
        if($hide_global_banner == 0){
            if($hide_banner){
                foreach(preg_split("/((\r?\n)|(\r\n?))/", $hide_banner) as $line){
                    $old_url = 'http://localhost:8888/moodle/edvik/';
                    $new_url = $CFG->wwwroot.'/';
                    $line = $line;
                    if (strpos($line, $old_url) !== false) {
                        $line = str_replace($old_url,$new_url,$line);
                    }
                    if ( $actual_link ==  $line):
                        return true;
                    endif;
                }
            }
        }else{
            return true;
        }
    }

    /**
     * if bottom content hide
     *
     * @return string
     */
    public function if_hide_page_bottom_content() {
        global $CFG;
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        $hide_page_bottom_content      = get_config('theme_edvik', 'hide_page_bottom_content');

        if($hide_page_bottom_content){
            foreach(preg_split("/((\r?\n)|(\r\n?))/", $hide_page_bottom_content) as $line){
                $old_url = 'http://localhost:8888/moodle/edvik/';
                $new_url = $CFG->wwwroot.'/';
                $line = $line;
                if (strpos($line, $old_url) !== false) {
                    $line = str_replace($old_url,$new_url,$line);
                }
                if ( $actual_link ==  $line):
                    return true;
                endif;
            }
        }
    }

    /**
     * enable_navbar_style_two
     *
     * @return string
     */
    public function enable_navbar_style_two() {
        global $CFG;
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        $enable_navbar_style_two     = get_config('theme_edvik', 'enable_navbar_style_two');

        if($enable_navbar_style_two){
            foreach(preg_split("/((\r?\n)|(\r\n?))/", $enable_navbar_style_two) as $line){
                $old_url = 'http://localhost:8888/moodle/edvik/';

                $new_url = $CFG->wwwroot.'/';
                $line = $line;
                if (strpos($line, $old_url) !== false) {
                    $line = str_replace($old_url,$new_url,$line);
                }
                if ( $actual_link ==  $line):
                    return true;
                endif;
            }
        }
    }

    /**
    * if admin
    *
    * @return string
    */
    public function edvik_if_admin() {
        if (is_siteadmin()) {
            return true;
        }else{
            return false;
        }
    }


    public function get_theme_image_favicon($maxwidth = null, $maxheight = 100) {
        global $CFG;
        if (!empty($this->page->theme->settings->favicon)) {
            $url = $this->page->theme->setting_file_url('favicon', 'favicon');
            // Get a URL suitable for moodle_url.
            $relativebaseurl = preg_replace('|^https?://|i', '//', $CFG->wwwroot);
            $url = str_replace($relativebaseurl, '', $url);
            return new moodle_url($url);
            return parent::get_theme_image_favicon($maxwidth, $maxheight);
        }
  
    }

    /**
     * Renders the context header for the page.
     *
     * @param array $headerinfo Heading information.
     * @param int $headinglevel What 'h' level to make the heading.
     * @return string A rendered context header.
     */
    public function context_header($headerinfo = null, $headinglevel = 1): string {
        global $DB, $USER, $CFG, $SITE;
        require_once($CFG->dirroot . '/user/lib.php');
        $context = $this->page->context;
        $heading = null;
        $imagedata = null;
        $subheader = null;
        $userbuttons = null;

        // Make sure to use the heading if it has been set.
        if (isset($headerinfo['heading'])) {
            $heading = $headerinfo['heading'];
        } else {
            $heading = $this->page->heading;
        }

        // The user context currently has images and buttons. Other contexts may follow.
        if ((isset($headerinfo['user']) || $context->contextlevel == CONTEXT_USER) && $this->page->pagetype !== 'my-index') {
            if (isset($headerinfo['user'])) {
                $user = $headerinfo['user'];
            } else {
                // Look up the user information if it is not supplied.
                $user = $DB->get_record('user', array('id' => $context->instanceid));
            }

            // If the user context is set, then use that for capability checks.
            if (isset($headerinfo['usercontext'])) {
                $context = $headerinfo['usercontext'];
            }

            // Only provide user information if the user is the current user, or a user which the current user can view.
            // When checking user_can_view_profile(), either:
            // If the page context is course, check the course context (from the page object) or;
            // If page context is NOT course, then check across all courses.
            $course = ($this->page->context->contextlevel == CONTEXT_COURSE) ? $this->page->course : null;

            if (user_can_view_profile($user, $course)) {
                // Use the user's full name if the heading isn't set.
                if (empty($heading)) {
                    $heading = fullname($user);
                }

                $imagedata = $this->user_picture($user, array('size' => 100));

                // Check to see if we should be displaying a message button.
                if (!empty($CFG->messaging) && has_capability('moodle/site:sendmessage', $context)) {
                    $userbuttons = array(
                        'messages' => array(
                            'buttontype' => 'message',
                            'title' => get_string('message', 'message'),
                            'url' => new moodle_url('/message/index.php', array('id' => $user->id)),
                            'image' => 'message',
                            'linkattributes' => \core_message\helper::messageuser_link_params($user->id),
                            'page' => $this->page
                        )
                    );

                    if ($USER->id != $user->id) {
                        $iscontact = \core_message\api::is_contact($USER->id, $user->id);
                        $contacttitle = $iscontact ? 'removefromyourcontacts' : 'addtoyourcontacts';
                        $contacturlaction = $iscontact ? 'removecontact' : 'addcontact';
                        $contactimage = $iscontact ? 'removecontact' : 'addcontact';
                        $userbuttons['togglecontact'] = array(
                                'buttontype' => 'togglecontact',
                                'title' => get_string($contacttitle, 'message'),
                                'url' => new moodle_url('/message/index.php', array(
                                        'user1' => $USER->id,
                                        'user2' => $user->id,
                                        $contacturlaction => $user->id,
                                        'sesskey' => sesskey())
                                ),
                                'image' => $contactimage,
                                'linkattributes' => \core_message\helper::togglecontact_link_params($user, $iscontact),
                                'page' => $this->page
                            );
                    }

                    $this->page->requires->string_for_js('changesmadereallygoaway', 'moodle');
                }
            } else {
                $heading = null;
            }
        }

        $prefix = null;
        if ($context->contextlevel == CONTEXT_MODULE) {
            if ($this->page->course->format === 'singleactivity') {
                $heading = $this->page->course->fullname;
            } else {
                $heading = $this->page->cm->get_formatted_name();
                $imagedata = $this->pix_icon('monologo', '', $this->page->activityname, ['class' => 'activityicon']);
                $purposeclass = plugin_supports('mod', $this->page->activityname, FEATURE_MOD_PURPOSE);
                $purposeclass .= ' activityiconcontainer';
                $purposeclass .= ' modicon_' . $this->page->activityname;
                $imagedata = html_writer::tag('div', $imagedata, ['class' => $purposeclass]);
                $prefix = get_string('modulename', $this->page->activityname);
            }
        }


        $contextheader = new \context_header($heading, $headinglevel, $imagedata, $userbuttons, $prefix);
        return $this->render_context_header($contextheader);
    }

     /**
      * Renders the header bar.
      *
      * @param context_header $contextheader Header bar object.
      * @return string HTML for the header bar.
      */
    protected function render_context_header(\context_header $contextheader) {

        // Generate the heading first and before everything else as we might have to do an early return.
        if (!isset($contextheader->heading)) {
            $heading = $this->heading($this->page->heading, $contextheader->headinglevel, 'h2');
        } else {
            $heading = $this->heading($contextheader->heading, $contextheader->headinglevel, 'h2');
        }

        // All the html stuff goes here.
        $html = html_writer::start_div('page-context-header');

        // Image data.
        if (isset($contextheader->imagedata)) {
            // Header specific image.
            $html .= html_writer::div($contextheader->imagedata, 'page-header-image mr-2');
        }

        // Headings.
        if (isset($contextheader->prefix)) {
            $prefix = html_writer::div($contextheader->prefix, 'text-muted text-uppercase small line-height-3');
            $heading = $prefix . $heading;
        }
        $html .= html_writer::tag('div', $heading, array('class' => 'page-header-headings'));

        // Buttons.
        if (isset($contextheader->additionalbuttons)) {
            $html .= html_writer::start_div('btn-group header-button-group');
            foreach ($contextheader->additionalbuttons as $button) {
                if (!isset($button->page)) {
                    // Include js for messaging.
                    if ($button['buttontype'] === 'togglecontact') {
                        \core_message\helper::togglecontact_requirejs();
                    }
                    if ($button['buttontype'] === 'message') {
                        \core_message\helper::messageuser_requirejs();
                    }
                    $image = $this->pix_icon($button['formattedimage'], $button['title'], 'moodle', array(
                        'class' => 'iconsmall',
                        'role' => 'presentation'
                    ));
                    $image .= html_writer::span($button['title'], 'header-button-title');
                } else {
                    $image = html_writer::empty_tag('img', array(
                        'src' => $button['formattedimage'],
                        'role' => 'presentation'
                    ));
                }
                $html .= html_writer::link($button['url'], html_writer::tag('span', $image), $button['linkattributes']);
            }
            $html .= html_writer::end_div();
        }
        $html .= html_writer::end_div();

        return $html;
    }

    /**
     * Banner Shape Image
     *
     * @return string
     */
    public function banner_bg_image() {
        $url = new moodle_url('/theme/edvik/pix/img/shape8.svg');
        return $url;
    }


    /**
     * if course details
     *
     * @return string
     */
    public function if_single_course() {
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        if ( strpos($actual_link, '/course/view.php?id=') != false ):
            return true;
        endif;
    }

    /**
     * if user enrolled
     *
     * @return string
     */
    public function edvik_if_user_enrolled() {

        global $USER;
        global $course;

        $courseid = $course->id;
        $userid = $USER->id;

        $context = context_course::instance($courseid);
        if(is_enrolled($context, $userid, '', true) == true):
            return false;
        else:
            return true;
        endif;

    }

    /**
     * enrol link
     *
     * @return string
     */
    public function edvik_enroll_link() {
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        $id = $_GET['id'];
        global $CFG;
        return $CFG->wwwroot . "/enrol/index.php?id=$id";
    }

    /**
     * if_guest
     */
    public function if_edvik_guest() {
        $hide_guest_access_curriculum       = '';
        $hide_guest_access_curriculum       = theme_edvik_get_setting('hide_guest_access_curriculum');

        if($hide_guest_access_curriculum){
            if (isguestuser()) {
                return true;
            }
        }
    }

    /**
     * course overview
     *
     * @return string
     */
    public function course_overview() {
        global $DB;
        global $course;
        $result = $DB->get_field("course", "summary", array("id"=>$course->id));
        $html .= $result;

        return $html;
    }

    /**
     * Get the footer bottom
     *
     */
    public function get_footer_bottom() {
        $footer_copyright       = '';
        $footer_copyright       = theme_edvik_get_setting('footer_copyright');
        ob_start();
        ?>
        <div class="copyright-text position-relative index-1">
            <p class="mb-0 text-center"><?php echo $footer_copyright; ?></p>
        </div>
        <?php
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }

    /**
     * Secure login info.
     *
     * @return string
     */
    public function secure_login_info() {
        return $this->login_info(false);
    }

    /**
     * Construct a user menu, returning HTML that can be echoed out by a
     * layout file.
     *
     * @param stdClass $user A user object, usually $USER.
     * @param bool $withlinks true if a dropdown should be built.
     * @return string HTML fragment.
     */
    public function user_menu($user = null, $withlinks = null) {
        global $USER, $CFG;
        require_once($CFG->dirroot . '/user/lib.php');

        if (is_null($user)) {
            $user = $USER;
        }

        // Note: this behaviour is intended to match that of core_renderer::login_info,
        // but should not be considered to be good practice; layout options are
        // intended to be theme-specific. Please don't copy this snippet anywhere else.
        if (is_null($withlinks)) {
            $withlinks = empty($this->page->layout_options['nologinlinks']);
        }

        // Add a class for when $withlinks is false.
        $usermenuclasses = 'usermenu';
        if (!$withlinks) {
            $usermenuclasses .= ' withoutlinks';
        }

        $returnstr = "";

        // If during initial install, return the empty return string.
        if (during_initial_install()) {
            return $returnstr;
        }

        $loginpage = $this->is_login_page();
        $loginurl = get_login_url();

        // Get some navigation opts.
        $opts = user_get_user_navigation_info($user, $this->page);

        if (!empty($opts->unauthenticateduser)) {
            $returnstr = get_string($opts->unauthenticateduser['content'], 'moodle');
            // If not logged in, show the typical not-logged-in string.
            if (!$loginpage && (!$opts->unauthenticateduser['guest'] || $withlinks)) {
                $returnstr .= " (<a href=\"$loginurl\">" . get_string('login') . '</a>)';
            }

            return html_writer::div(
                html_writer::span(
                    $returnstr,
                    'login nav-link'
                ),
                $usermenuclasses
            );
        }

        $avatarclasses = "avatars";
        $avatarcontents = html_writer::span($opts->metadata['useravatar'], 'avatar current');
        $usertextcontents = $opts->metadata['userfullname'];

        // Other user.
        if (!empty($opts->metadata['asotheruser'])) {
            $avatarcontents .= html_writer::span(
                $opts->metadata['realuseravatar'],
                'avatar realuser'
            );
            $usertextcontents = $opts->metadata['realuserfullname'];
            $usertextcontents .= html_writer::tag(
                'span',
                get_string(
                    'loggedinas',
                    'moodle',
                    html_writer::span(
                        $opts->metadata['userfullname'],
                        'value'
                    )
                ),
                array('class' => 'meta viewingas')
            );
        }

        // Role.
        if (!empty($opts->metadata['asotherrole'])) {
            $role = core_text::strtolower(preg_replace('#[ ]+#', '-', trim($opts->metadata['rolename'])));
            $usertextcontents .= html_writer::span(
                $opts->metadata['rolename'],
                'meta role role-' . $role
            );
        }

        // User login failures.
        if (!empty($opts->metadata['userloginfail'])) {
            $usertextcontents .= html_writer::span(
                $opts->metadata['userloginfail'],
                'meta loginfailures'
            );
        }

        // MNet.
        if (!empty($opts->metadata['asmnetuser'])) {
            $mnet = strtolower(preg_replace('#[ ]+#', '-', trim($opts->metadata['mnetidprovidername'])));
            $usertextcontents .= html_writer::span(
                $opts->metadata['mnetidprovidername'],
                'meta mnet mnet-' . $mnet
            );
        }

        $returnstr .= html_writer::span(
            html_writer::span($usertextcontents, 'usertext mr-1') .
            html_writer::span($avatarcontents, $avatarclasses),
            'userbutton'
        );

        // Create a divider (well, a filler).
        $divider = new action_menu_filler();
        $divider->primary = false;

        $am = new action_menu();
        $am->set_menu_trigger(
            $returnstr,
            'nav-link'
        );
        $am->set_action_label(get_string('usermenu'));
        $am->set_nowrap_on_items();
        $edvik_nav_items = '';
        if ($withlinks) {
            $navitemcount = count($opts->navitems);
            $idx = 0;
            foreach ($opts->navitems as $key => $value) {


                switch ($value->itemtype) {
                    case 'divider':
                        // If the nav item is a divider, add one and skip link processing.
                        $am->add($divider);
                        break;

                    case 'invalid':
                        // Silently skip invalid entries (should we post a notification?).
                        break;

                    case 'link':                        
                        $edvik_nav_items .= '<a class="dropdown-item" href="'. $value->url .'">'. $value->title .'</a>';

                        // Process this as a link item.
                        $pix = null;
                        if (isset($value->pix) && !empty($value->pix)) {
                            $pix = new pix_icon($value->pix, '', null, array('class' => 'iconsmall'));
                        } else if (isset($value->imgsrc) && !empty($value->imgsrc)) {
                            $value->title = html_writer::img(
                                $value->imgsrc,
                                $value->title,
                                array('class' => 'iconsmall')
                            ) . $value->title;
                        }

                        $al = new action_menu_link_secondary(
                            $value->url,
                            $pix,
                            $value->title,
                            array('class' => 'icon')
                        );
                        if (!empty($value->titleidentifier)) {
                            $al->attributes['data-title'] = $value->titleidentifier;
                        }
                        $am->add($al);
                        break;
                }

                $idx++;

                // Add dividers after the first item and before the last item.
                if ($idx == 1 || $idx == $navitemcount - 1) {
                    $am->add($divider);
                }
            }
        }        
        return $edvik_nav_items;
    }

    /**
     * region_main_settings_menu
     */
    public function edvik_region_main_settings_menu() {
        global $OUTPUT;

        $header = $this->context_header_settings_menu();

        if (!$this->page->blocks->is_block_present('settings')) {
            return $header;
        }

    }

    /**
     * Outputs a heading
     * @param string $text The text of the heading
     * @param int $level The level of importance of the heading. Defaulting to 2
     * @param string $classes A space-separated list of CSS classes
     * @param string $id An optional ID
     * @return string the HTML to output.
     */
    public function heading($text, $level = 2, $classes = 'main page-section-title-hide', $id = null) {
        return "<h3 id='$id' class='$classes'>$text</h3>";
    }
    /**
     * Returns standard main content placeholder.
     * Designed to be called in theme layout.php files.
     *
     * @return string HTML fragment.
     */
    public function main_content() {
        // This is here because it is the only place we can inject the "main" role over the entire main content area
        // without requiring all theme's to manually do it, and without creating yet another thing people need to
        // remember in the theme.
        // This is an unfortunate hack. DO NO EVER add anything more here.
        // DO NOT add classes.
        // DO NOT add an id.
        return $this->unique_main_content_token;
    }

    public function firstview_fakeblocks(): bool {
        global $SESSION;

        $firstview = false;
        if ($this->page->cm) {
            if (!$this->page->blocks->region_has_fakeblocks('side-pre')) {
                return false;
            }
            if (!property_exists($SESSION, 'firstview_fakeblocks')) {
                $SESSION->firstview_fakeblocks = [];
            }
            if (array_key_exists($this->page->cm->id, $SESSION->firstview_fakeblocks)) {
                $firstview = false;
            } else {
                $SESSION->firstview_fakeblocks[$this->page->cm->id] = true;
                $firstview = true;
                if (count($SESSION->firstview_fakeblocks) > 100) {
                    array_shift($SESSION->firstview_fakeblocks);
                }
            }
        }
        return $firstview;
    }

    
}