@mod @mod_lesson
Feature: In a lesson activity, students can navigate through a series of pages in various ways depending upon their answers to questions
  In order to create a lesson with conditional paths
  As a teacher
  I need to add pages and questions with links between them

  Background:
    Given the following "users" exist:
      | username | firstname | lastname | email |
      | teacher1 | Teacher | 1 | teacher1@example.com |
      | student1 | Student | 1 | student1@example.com |
    And the following "courses" exist:
      | fullname | shortname | category |
      | Course 1 | C1 | 0 |
    And the following "course enrolments" exist:
      | user | course | role |
      | teacher1 | C1 | editingteacher |
      | student1 | C1 | student |
    And I log in as "teacher1"

  Scenario: Student navigation with pages and questions
    Given the following "activities" exist:
      | activity   | name             | intro                   | course | idnumber    |
      | lesson     | Test lesson name | Test lesson description | C1     | lesson1     |
    And I am on "Course 1" course homepage
    And I follow "Test lesson name"
    And I follow "Add a content page"
    And I set the following fields to these values:
      | Page title | First page name |
      | Page contents | First page contents |
      | id_answer_editor_0 | Next page |
      | id_jumpto_0 | Next page |
    And I press "Save page"
    And I select "Add a content page" from the "qtype" singleselect
    And I set the following fields to these values:
      | Page title | Second page name |
      | Page contents | Second page contents |
      | id_answer_editor_0 | Previous page |
      | id_jumpto_0 | Previous page |
      | id_answer_editor_1 | Next page |
      | id_jumpto_1 | Next page |
    And I press "Save page"
    And I follow "Expanded"
    And I click on "Add a question page here" "link" in the "//div[contains(concat(' ', normalize-space(@class), ' '), ' addlinks ')][3]" "xpath_element"
    And I set the field "Select a question type" to "Numerical"
    And I press "Add a question page"
    And I set the following fields to these values:
      | Page title | Hardest question ever |
      | Page contents | 1 + 1? |
      | id_answer_editor_0 | 2 |
      | id_response_editor_0 | Correct answer |
      | id_jumpto_0 | End of lesson |
      | id_score_0 | 1 |
      | id_answer_editor_1 | 1 |
      | id_response_editor_1 | Incorrect answer |
      | id_jumpto_1 | Second page name |
      | id_score_1 | 0 |
    And I press "Save page"
    And I log out
    And I log in as "student1"
    And I am on "Course 1" course homepage
    When I follow "Test lesson name"
    Then I should see "First page contents"
    And I press "Next page"
    And I should see "Second page contents"
    And I should not see "First page contents"
    And I press "Previous page"
    And I should see "First page contents"
    And I should not see "Second page contents"
    And I press "Next page"
    And I should see "Second page contents"
    And I press "Next page"
    And I should see "1 + 1?"
    And I set the following fields to these values:
      | Your answer | 1 |
    And I press "Submit"
    And I should see "Incorrect answer"
    And I press "Continue"
    And I should see "Second page name"
    And I press "Next page"
    And I should see "1 + 1?"
    And I set the following fields to these values:
      | Your answer | 2 |
    And I press "Submit"
    And I should see "Maximum number of attempts reached - Moving to next page"
    And I press "Continue"
    And I should see "Congratulations - end of lesson reached"
    And I should see "Your score is 0 (out of 1)."

  Scenario: Student reattempts a question until out of attempts
    Given the following "activities" exist:
      | activity   | name             | intro                   | course | idnumber    |
      | lesson     | Test lesson name | Test lesson description | C1     | lesson1     |
    And I am on "Course 1" course homepage
    And I follow "Test lesson name"
    And I navigate to "Edit settings" in current page administration
    And I set the following fields to these values:
      | id_review | Yes |
      | id_maxattempts | 3 |
    And I press "Save and return to course"
    And I follow "Test lesson name"
    And I follow "Add a question page"
    And I set the following fields to these values:
      | id_qtype | True/false |
    And I press "Add a question page"
    And I set the following fields to these values:
      | Page title | Test question |
      | Page contents | Test content |
      | id_answer_editor_0 | right |
      | id_answer_editor_1 | wrong |
    And I press "Save page"
    And I log out
    And I log in as "student1"
    And I am on "Course 1" course homepage
    When I follow "Test lesson name"
    Then I should see "Test content"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should see "You have 2 attempt(s) remaining"
    And I press "Yes, I'd like to try again"
    And I should see "Test content"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should see "You have 1 attempt(s) remaining"
    And I press "Yes, I'd like to try again"
    And I should see "Test content"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should not see "Yes, I'd like to try again"
    And I press "Continue"
    And I should see "Congratulations - end of lesson reached"

  Scenario: Student reattempts a question until out of attempts with specific jumps
    Given the following "activities" exist:
      | activity   | name             | intro                   | course | idnumber    |
      | lesson     | Test lesson name | Test lesson description | C1     | lesson1     |
    And I am on the "Test lesson name" "lesson activity" page
    And I navigate to "Edit settings" in current page administration
    And I set the following fields to these values:
      | id_review      | Yes |
      | id_maxattempts | 3   |
    And I press "Save and return to course"
    And I follow "Test lesson name"
    And I follow "Add a question page"
    And I set the following fields to these values:
      | id_qtype | True/false |
    And I press "Add a question page"
    And I set the following fields to these values:
      | Page title         | Test question  |
      | Page contents      | Test content 1 |
      | id_answer_editor_0 | right          |
      | id_answer_editor_1 | wrong          |
    And I press "Save page"
    And I select "Add a question page" from the "qtype" singleselect
    And I set the field "Select a question type" to "True/false"
    And I press "Add a question page"
    And I set the following fields to these values:
      | Page title         | Test question 2 |
      | Page contents      | Test content 2  |
      | id_answer_editor_0 | right           |
      | id_jumpto_0        | Test question   |
      | id_answer_editor_1 | wrong           |
      | id_jumpto_1        | Test question   |
    And I press "Save page"
    And I log out
    When I am on the "Test lesson name" "lesson activity" page logged in as student1
    Then I should see "Test content 1"
    And I set the following fields to these values:
      | right | 1 |
    And I press "Submit"
    And I should see "Test content 2"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should see "You have 2 attempt(s) remaining"
    And I press "Yes, I'd like to try again"
    And I should see "Test content 2"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should see "You have 1 attempt(s) remaining"
    And I press "Yes, I'd like to try again"
    And I should see "Test content 2"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should not see "Yes, I'd like to try again"
    And I press "Continue"
    And I should see "Test content 1"

  Scenario: Student should not see remaining attempts notification if maximum number of attempts is set to unlimited
    Given the following "activities" exist:
      | activity   | name             | intro                   | course | idnumber    |
      | lesson     | Test lesson name | Test lesson description | C1     | lesson1     |
    And I am on "Course 1" course homepage
    And I follow "Test lesson name"
    And I navigate to "Edit settings" in current page administration
    And I set the following fields to these values:
      | id_review | Yes |
      | id_maxattempts | 0 |
    And I press "Save and return to course"
    And I follow "Test lesson name"
    And I follow "Add a question page"
    And I set the following fields to these values:
      | id_qtype | True/false |
    And I press "Add a question page"
    And I set the following fields to these values:
      | Page title | Test question |
      | Page contents | Test content |
      | id_answer_editor_0 | right |
      | id_answer_editor_1 | wrong |
    And I press "Save page"
    And I log out
    And I log in as "student1"
    And I am on "Course 1" course homepage
    When I follow "Test lesson name"
    Then I should see "Test content"
    And I set the following fields to these values:
      | wrong | 1 |
    And I press "Submit"
    And I should not see "attempt(s) remaining"
    And I press "Yes, I'd like to try again"
    And I should see "Test content"
    And I set the following fields to these values:
      | right | 1 |
    And I press "Submit"
    And I should not see "Yes, I'd like to try again"
    And I should see "Congratulations - end of lesson reached"
