/**
 * This module instantiates the functionality for actions on course certificates.
 *
 * @module      mod_coursecertificate/manager
 * @copyright   2020 Mikel Martín <mikel@moodle.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_coursecertificate/manager",["core/ajax","core/notification","core/templates","core/str"],(function(Ajax,Notification,Templates,Str){var SELECTORS_AUTOMATICSENDREGION="[data-region='automaticsend-alert']",SELECTORS_HIDDENWARNING=".hidden-warning",SELECTORS_NOAUTOSENDINFO=".noautosend-info",SELECTORS_REPORTREGION="[data-region='issues-report']",SELECTORS_TOGGLEAUTOMATICSEND="[data-action='toggle-automaticsend']",SELECTORS_REVOKEISSUE="[data-action='revoke-issue']",SELECTORS_LOADING=".loading-overlay",TEMPLATES_AUTOMATICSENDALERT="mod_coursecertificate/automaticsend_alert",SERVICES_UPDATEAUTOMATICSEND="mod_coursecertificate_update_automaticsend",SERVICES_REVOKEISSUE="tool_certificate_revoke_issue";function setVisibility(selector,visibile){visibile?(document.querySelector(selector).classList.remove("d-none"),document.querySelector(selector).classList.remove("invisible")):(document.querySelector(selector).classList.add("d-none"),document.querySelector(selector).classList.add("invisible"))}return{init:function(){var automaticsendregion=document.querySelector(SELECTORS_AUTOMATICSENDREGION);automaticsendregion&&automaticsendregion.addEventListener("click",(function(e){e.target&&e.target.closest(SELECTORS_TOGGLEAUTOMATICSEND)&&(e.preventDefault(),function(automaticsendregion){var _automaticsendregion$=automaticsendregion.querySelector(SELECTORS_TOGGLEAUTOMATICSEND).dataset,certificateid=_automaticsendregion$.certificateid,newstatus="0"===_automaticsendregion$.automaticsend,strings=newstatus?[{key:"confirmation",component:"admin"},{key:"enableautomaticsendpopup",component:"coursecertificate"},{key:"confirm"},{key:"cancel"}]:[{key:"confirmation",component:"admin"},{key:"disableautomaticsend",component:"coursecertificate"},{key:"confirm"},{key:"cancel"}];Str.get_strings(strings).then((function(s){return Notification.confirm(s[0],s[1],s[2],s[3],(function(){M.util.js_pending("mod_coursecertificate_toggle_automaticsend"),setVisibility(SELECTORS_LOADING,!0),Ajax.call([{methodname:SERVICES_UPDATEAUTOMATICSEND,args:{id:certificateid,automaticsend:newstatus}}])[0].then((function(result){var showhiddenwarning=result.showhiddenwarning,shownoautosendinfo=result.shownoautosendinfo;return Templates.render(TEMPLATES_AUTOMATICSENDALERT,{certificateid:certificateid,automaticsend:newstatus},"").then((function(html){return automaticsendregion.innerHTML=html,setVisibility(SELECTORS_HIDDENWARNING,showhiddenwarning),setVisibility(SELECTORS_NOAUTOSENDINFO,shownoautosendinfo),M.util.js_complete("mod_coursecertificate_toggle_automaticsend"),null})).fail(Notification.exception),null})).fail(Notification.exception)})),null})).fail(Notification.exception)}(automaticsendregion))}));var reportregion=document.querySelector(SELECTORS_REPORTREGION);reportregion&&reportregion.addEventListener("click",(function(e){var target=e.target&&e.target.closest(SELECTORS_REVOKEISSUE);target&&(e.preventDefault(),function(issueid){Str.get_strings([{key:"confirmation",component:"admin"},{key:"revokeissue",component:"coursecertificate"},{key:"confirm"},{key:"cancel"}]).then((function(s){return Notification.confirm(s[0],s[1],s[2],s[3],(function(){M.util.js_pending("mod_coursecertificate_revoke_issue"),Ajax.call([{methodname:SERVICES_REVOKEISSUE,args:{id:issueid}}])[0].then((function(){return M.util.js_complete("mod_coursecertificate_revoke_issue"),window.location.reload(),null})).fail(Notification.exception)})),null})).fail(Notification.exception)}(target.dataset.issueid))}))}}}));

//# sourceMappingURL=manager.min.js.map