/**
 * AMD module used when editing a single template
 *
 * @module     tool_certificate/template-edit
 * @copyright  2019 Marina Glancy
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_certificate/template-edit",["jquery","jqueryui","tool_certificate/modal_form","core/notification","core/str","core/ajax","core/sortable_list"],(function($,jqui,ModalForm,Notification,Str,Ajax,SortableList){var editReportDetailsHandler=function(e){e.preventDefault();var el=$(e.currentTarget),id=el.attr("data-id"),name=el.attr("data-name");new ModalForm({formClass:"tool_certificate\\form\\details",args:{id:id},modalConfig:{title:Str.get_string("editcertificate","tool_certificate",name)},saveButtonText:Str.get_string("save"),triggerElement:el}).onSubmitSuccess=function(){window.location.reload()}},deleteElement=function(e){e.preventDefault(),Str.get_strings([{key:"confirm",component:"moodle"},{key:"deleteelementconfirm",component:"tool_certificate",param:$(e.currentTarget).attr("data-name")},{key:"delete",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(s){Notification.confirm(s[0],s[1],s[2],s[3],(function(){Ajax.call([{methodname:"tool_certificate_delete_element",args:{id:$(e.currentTarget).attr("data-id")}}])[0].done((function(){window.location.reload()})).fail(Notification.exception)}))})).fail(Notification.exception)},editElement=function(e){(e.preventDefault(),$(e.currentTarget).hasClass("isdragged"))||(new ModalForm({formClass:"tool_certificate\\edit_element_form",args:{id:$(e.currentTarget).attr("data-id")},modalConfig:{title:Str.get_string("editelement","tool_certificate",$(e.currentTarget).attr("data-name"))},saveButtonText:Str.get_string("save"),triggerElement:$(e.currentTarget)}).onSubmitSuccess=function(){window.location.reload()})},addElement=function(e){e.preventDefault();var pageid=$(e.currentTarget).attr("data-pageid"),type=$(e.currentTarget).attr("data-element");new ModalForm({formClass:"tool_certificate\\edit_element_form",args:{pageid:pageid,element:type},modalConfig:{title:Str.get_string("addelementwithname","tool_certificate",$(e.currentTarget).text())},saveButtonText:Str.get_string("save"),triggerElement:$(e.currentTarget)}).onSubmitSuccess=function(){window.location.reload()}},deletePage=function(e){e.preventDefault(),Str.get_strings([{key:"confirm",component:"moodle"},{key:"deletepageconfirm",component:"tool_certificate"},{key:"delete",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(s){Notification.confirm(s[0],s[1],s[2],s[3],(function(){window.location.href=$(e.currentTarget).attr("href")}))})).fail(Notification.exception)},addPage=function(e){e.preventDefault(),new ModalForm({formClass:"tool_certificate\\form\\page",args:{templateid:$('[data-region="template"][data-id]').attr("data-id")},modalConfig:{title:Str.get_string("addcertpage","tool_certificate")},saveButtonText:Str.get_string("save"),triggerElement:$(e.currentTarget)}).onSubmitSuccess=function(){window.location.reload()}},editPage=function(e){e.preventDefault(),new ModalForm({formClass:"tool_certificate\\form\\page",args:{id:$(e.currentTarget).attr("data-id")},modalConfig:{title:Str.get_string("editpage","tool_certificate",$(e.currentTarget).attr("data-pagenumber"))},saveButtonText:Str.get_string("save"),triggerElement:$(e.currentTarget)}).onSubmitSuccess=function(){window.location.reload()}},mmToPx=function(value){return 2*parseFloat(value)},pxToMm=function(value){return Math.round(parseFloat(value)/2)},recalculatePDF=function(){var page=$(this);page.css("width",mmToPx(page.data("pagewidth"))+"px"),page.css("height",mmToPx(page.data("pageheight"))+"px"),page.find("[data-width]").each((function(){$(this).css("width",mmToPx($(this).data("width"))+"px")})),page.find("[data-height]").each((function(){$(this).css("height",mmToPx($(this).data("height"))+"px")})),page.find("[data-fontsize]").each((function(){var value;$(this).css("font-size",(value=$(this).data("fontsize"),.352778*mmToPx(value)+"px"))})),page.find("[data-posy]").each((function(){$(this).css("top",mmToPx($(this).data("posy"))+"px")})),page.find("[data-posx]").each((function(){var left=mmToPx($(this).data("posx")),refpoint=$(this).data("refpoint")?parseInt($(this).data("refpoint")):0,offset=refpoint?parseInt($(this).width())*refpoint/2:0;$(this).css("left",left-offset+"px")})),page.addClass("recalculated"),page.find('[data-drag-type="move"]').draggable()};return{init:function(){var selector;$('[data-action="editdetails"]').on("click",editReportDetailsHandler),$('[data-action="deleteelement"]').on("click",deleteElement),$('[data-action="editelement"]').on("click",editElement),$('[data-action="addelement"]').on("click",addElement),$('[data-action="deletepage"]').on("click",deletePage),$('[data-element="addbutton"]').on("click",addPage),$('[data-action="editpage"]').on("click",editPage),$('[data-region="page"]').each((function(){new SortableList($(this).find('[data-region="elementlist"]')).getElementName=function(element){return $.Deferred().resolve(element.find("a.quickeditlink").text())},$(this).on(SortableList.EVENTS.DROP,'[data-region="elementlist"] > *',(function(_,info){if(info.positionChanged){var request={methodname:"tool_certificate_update_element",args:{id:info.element.data("id"),sequence:info.element.index()+1}};Ajax.call([request])[0].fail(Notification.exception)}}))})),selector='[data-region="pdf"] [data-drag-type="move"]',$("body").on("mousedown",selector,(function(e){var el=$(e.currentTarget),page=el.closest('[data-region="pdf"]');page.find('[data-region="pagecenter"]').css("left",mmToPx(page.data("pagecentre"))-el.width()/2+"px").css("width",el.width()+"px"),el.draggable({snap:!e.shiftKey&&".snapdraggable",snapMode:"inner",snapTolerance:10,containment:[page.offset().left-el.width(),page.offset().top-el.height(),page.offset().left+mmToPx(page.data("pagewidth")),page.offset().top+mmToPx(page.data("pageheight"))]})})).on("dragstart",selector,(function(e){$(e.currentTarget).addClass("isdragged")})).on("dragstop",selector,(function(e){var el=$(e.currentTarget),page=el.closest('[data-region="pdf"]'),refpoint=parseInt($(this).data("refpoint")),offset=refpoint?parseInt($(this).width())*refpoint/2:0,left=pxToMm(el.offset().left-page.offset().left+offset),top=pxToMm(el.offset().top-page.offset().top);setTimeout((function(){el.removeClass("isdragged")}),100);var request={methodname:"tool_certificate_update_element",args:{id:el.data("id"),posx:left,posy:top}};Ajax.call([request])[0].fail(Notification.exception)})),$('[data-region="pdf"]').each(recalculatePDF)}}}));

//# sourceMappingURL=template-edit.min.js.map