/**
 * Display a form in a modal dialogue
 *
 * @module     tool_certificate/modal_form
 * @copyright  2018 Mitxel Moriana
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_certificate/modal_form",["jquery","core/modal_factory","core/modal_events","core/ajax","core/notification","core/yui","core/event","core/str"],(function($,ModalFactory,ModalEvents,Ajax,Notification,Y,Event,Str){var ModalForm=function(config){this.config=config,this.config.modalConfig=this.config.modalConfig||{},this.config.modalConfig.type=this.config.modalConfig.type||ModalFactory.types.SAVE_CANCEL,this.config.args=this.config.args||{},this.init()};ModalForm.prototype.config={},ModalForm.prototype.modal=null,ModalForm.prototype.init=function(){M.util.js_pending("tool_certificate_modal_form_init"),Str.get_strings([{key:"collapseall",component:"moodle"},{key:"expandall",component:"moodle"}]).then(function(){return ModalFactory.create(this.config.modalConfig)}.bind(this)).then(function(modal){return this.modal=modal,this.modal.setBody(this.getBody($.param(this.config.args))),this.modal.setLarge(),this.modal.getRoot().on(ModalEvents.hidden,function(){Event.notifyFormSubmitAjax(this.modal.getRoot().find("form")[0],!0),this.modal.destroy(),this.resetDirtyFormState(),null!==this.config.triggerElement&&this.config.triggerElement.focus()}.bind(this)),this.modal.getModal().addClass("tool-wp-modal-form-dialogue"),this.modal.getRoot().on("click","form input[type=submit][data-no-submit]",this.noSubmitButtonPressed.bind(this)),this.modal.getRoot().on("submit","form",this.submitFormAjax.bind(this)),void 0!==this.config.saveButtonText&&void 0!==this.modal.setSaveButtonText&&this.modal.setSaveButtonText(this.config.saveButtonText),this.onInit(),this.modal.show(),M.util.js_complete("tool_certificate_modal_form_init"),this.modal}.bind(this)).fail(Notification.exception)},ModalForm.prototype.onInit=function(){this.modal.getRoot().on(ModalEvents.save,this.submitForm.bind(this))},ModalForm.prototype.getBody=function(formDataString){var promise=$.Deferred(),params={formdata:formDataString,form:this.config.formClass};return M.util.js_pending("tool_certificate_modal_form_body"),Ajax.call([{methodname:"tool_certificate_modal_form",args:params}])[0].then((function(response){return promise.resolve(response.html,processCollectedJavascript(response.javascript)),M.util.js_complete("tool_certificate_modal_form_body"),null})).fail((function(ex){promise.reject(ex)})),promise.promise()},ModalForm.prototype.onSubmitSuccess=function(response){return response},ModalForm.prototype.onValidationError=function(){},ModalForm.prototype.onSubmitError=function(exception){Notification.exception(exception)},ModalForm.prototype.resetDirtyFormState=function(){Y.use("moodle-core-formchangechecker",(function(){M.core_formchangechecker.reset_form_dirty_state()}))},ModalForm.prototype.noSubmitButtonPressed=function(e){e.preventDefault(),Event.notifyFormSubmitAjax(this.modal.getRoot().find("form")[0],!0);var formData=this.modal.getRoot().find("form").serialize(),el=$(e.currentTarget);formData=formData+"&"+encodeURIComponent(el.attr("name"))+"="+encodeURIComponent(el.attr("value")),this.modal.setBody(this.getBody(formData))},ModalForm.prototype.validateElements=function(){Event.notifyFormSubmitAjax(this.modal.getRoot().find("form")[0]);var invalid=$.merge(this.modal.getRoot().find('[aria-invalid="true"]'),this.modal.getRoot().find(".error"));return!invalid.length||(invalid.first().focus(),!1)},ModalForm.prototype.disableButtons=function(){this.modal.getFooter().find("[data-action]").attr("disabled",!0)},ModalForm.prototype.enableButtons=function(){this.modal.getFooter().find("[data-action]").removeAttr("disabled")},ModalForm.prototype.submitFormAjax=function(e){if(e.preventDefault(),this.validateElements()){this.disableButtons();var formData=this.modal.getRoot().find("form").serialize();Ajax.call([{methodname:"tool_certificate_modal_form",args:{formdata:formData,form:this.config.formClass}}])[0].then(function(response){if(response.submitted){var data=JSON.parse(response.data);this.modal.hide(),this.onSubmitSuccess(data)}else{var promise=$.Deferred();promise.resolve(response.html,processCollectedJavascript(response.javascript)),this.modal.setBody(promise.promise()),this.enableButtons(),this.onValidationError()}return null}.bind(this)).fail(this.onSubmitError.bind(this))}},ModalForm.prototype.submitForm=function(e){e.preventDefault(),this.modal.getRoot().find("form").submit()};var processCollectedJavascript=function(js){var jsNodes=$(js),allScript="";return jsNodes.each((function(index,scriptNode){var tagName=(scriptNode=$(scriptNode)).prop("tagName");if(tagName&&"script"===tagName.toLowerCase())if(scriptNode.attr("src")){var exists=!1;$("script").each((function(index,s){return $(s).attr("src")===scriptNode.attr("src")&&(exists=!0),!exists})),exists||(allScript+=" { ",allScript+=' node = document.createElement("script"); ',allScript+=' node.type = "text/javascript"; ',allScript+=' node.src = decodeURI("'+encodeURI(scriptNode.attr("src"))+'"); ',allScript+=' document.getElementsByTagName("head")[0].appendChild(node); ',allScript+=" } ")}else allScript+=" "+scriptNode.text()})),allScript};return ModalForm}));

//# sourceMappingURL=modal_form.min.js.map